#ifndef __OMS_OBJECTCONTAINER_HPP
#define __OMS_OBJECTCONTAINER_HPP

#include "Oms/OMS_ObjectContainerDef.hpp"
#include "Oms/OMS_ClassIdEntry.hpp"
#include "Oms/OMS_GuidEntry.hpp"
#include "Oms/OMS_VarObjInfo.hpp"

inline tsp00_Int4 OmsObjectContainer::headerSize() 
{
  return (sizeof (OmsObjectContainer) - sizeof (OmsAbstractObject));
}

inline void OmsObjectContainer::InitObjContainer(OMS_GuidEntry& classInfo)
{
  void** pvtptr  = REINTERPRET_CAST(void**, (&m_pobj));
  *pvtptr        = classInfo.GetVirtualTablePtr();
  this->InitState(&classInfo);
  m_verstate = 0;
  m_beforeImages = 0;
  m_hashnext     = NULL;
  m_containerInfo   = NULL;
  m_objseq.gg91SetNilRef(); 
}

inline void OmsObjectContainer::InitObjContainer(OMS_ClassIdEntry& clsinfo) 
{
  void** pvtptr  = REINTERPRET_CAST(void**, (&m_pobj));
  *pvtptr        = clsinfo.GetVirtualTablePtr();
  this->InitState(&clsinfo);
  m_verstate = 0;
  m_beforeImages = 0;
  m_hashnext     = NULL;
  m_containerInfo   = NULL;
  m_objseq.gg91SetNilRef(); 
}

inline void OmsObjectContainer::InitState(OMS_GuidEntry* classInfo) 
{
  m_state = 0;
  if ((NULL != classInfo) && (classInfo->IsVarObject())) {
    this->MarkVarObj();
  }
}

inline void OmsObjectContainer::InitState(OMS_ClassIdEntry* clsinfo) 
{ // TODO ?
  m_state = 0;
  if ((NULL != clsinfo) && (clsinfo->IsVarObject())) {
    this->MarkVarObj();
  }
}

inline tsp00_Uint4 OmsObjectContainer::GetContainerHandle() const 
{
  return m_containerInfo->GetContainerHandle();
}

inline void OmsObjectContainer::ChainFree(OMS_Context* context)
{
  OMS_ClassIdEntry* containerInfo = m_containerInfo;
  OmsObjectContainerPtr p = REINTERPRET_CAST(OmsObjectContainerPtr, this);
  containerInfo->chainFree(*context, p);
}

inline OMS_ClassIdEntry* OmsObjectContainer::GetContainerInfo(OMS_Context* context)
{
  context->CheckIfContainerNotDropped(m_containerInfo);
  return m_containerInfo;
}

inline OMS_ClassIdEntry* OmsObjectContainer::GetContainerInfoNoCheck(OMS_Context* context) 
{
  return m_containerInfo;
}

inline void OmsObjectContainer::Copy (OMS_Context* c, OmsObjectContainerPtr beforeImage, int ObjectSize)
{
  tsp00_Int2 refCnt;
  if (this->VarObjFlag()) {
    _OMSASSERT(c->m_session,
      REINTERPRET_CAST(OMS_VarObjInfo*, &beforeImage->m_pobj)->m_vobjInfo.m_vobjNext == 
      REINTERPRET_CAST(OMS_VarObjInfo*, &this->m_pobj)->m_vobjInfo.m_vobjNext);
    refCnt = REINTERPRET_CAST(OMS_VarObjInfo*, &m_pobj)->m_refCnt;
    REINTERPRET_CAST(OMS_VarObjInfo*, &m_pobj)->freeVarObjData(c);
  }
  memcpy (&m_oid, &beforeImage->m_oid, ObjectSize - sizeof(m_hashnext));
  if (this->VarObjFlag()) {
    REINTERPRET_CAST(OMS_VarObjInfo*, &m_pobj)->m_refCnt = refCnt;
    REINTERPRET_CAST(OMS_VarObjInfo*, &beforeImage->m_pobj)->m_pvobj = NULL;
  }
}

inline int OmsObjectContainer::Compare(OMS_Context* c, OmsObjectContainerPtr beforeImage, int ObjectSize)
{
  if (this->VarObjFlag()) {
    // TODO: compare VarObjs
    return 0;
  } else {
    return memcmp(reinterpret_cast<const void**>(&m_pobj) + 1,
      reinterpret_cast<const void**>(&beforeImage->m_pobj) + 1,
      ObjectSize);
  }
}

#endif  // __OMS_OBJECTCONTAINER_HPP
