#include "Oms/OMS_ClassInfo.hpp"
#include "Oms/OMS_ContainerInfo.hpp"
#include "Oms/OMS_Globals.hpp"

/*----------------------------------------------------------------------------------*/

OMS_ClassInfo::OMS_ClassInfo(const char*              ClassName, 
                             const ClassIDRef         Guid,
                             const OMS_ClassInfo     *pBaseClass,
                             tsp00_Int4                keyPos,         // PTS 1122540
                             tsp00_Int4                keyLen,         // PTS 1122540
                             bool                      keyPartitioned, // PTS 1122540
                             size_t                    ObjSize, 
                             void                     *vtptr, 
                             OMS_ClassInfo            *HashNext)
                             :  
                             m_guid(Guid),
                             m_ObjectSize(ObjSize),
                             m_VTPtr(vtptr),
                             m_pBaseClass(pBaseClass),
                             m_HashNext(HashNext),
                             m_isBaseClass(false), 
                             m_isDerivedClass(pBaseClass != NULL),
                             m_isVarObject(false),
                             m_KeyDesc(keyPos, keyLen, keyPartitioned)  // PTS 1122540
{
  size_t ClassNameLength = strlen(ClassName);
  if (ClassNameLength >= sizeof(m_ClassName)) {
    ClassNameLength = sizeof(m_ClassName) - 1;
  }
  memcpy (&m_ClassName[0], ClassName, ClassNameLength);
  m_ClassName[ClassNameLength] = 0;

#ifdef LIVECACHE_INTGUIDS
  m_isVarObject = (Guid == OMS_VAR_OBJ_GUID);
#else
  m_isVarObject = (0 == memcmp(&Guid, &OMS_VAR_OBJ_GUID, sizeof(Guid)));
#endif
}


/*----------------------------------------------------------------------------------*/

void* OMS_ClassInfo::operator new(size_t sz) 
{
  return OMS_Globals::m_sharedMemAllocatorInstance.allocate(sz);
}

/*----------------------------------------------------------------------------------*/

void OMS_ClassInfo::DeleteSelf()
{
#if defined(_ASSERT_OMS)
  memset (this, 0, sizeof(*this));
#endif
  OMS_Globals::m_sharedMemAllocatorInstance.deallocate(this);
}

/*----------------------------------------------------------------------------------*/

#if defined(OMS_PLACEMENT_DELETE)

void  OMS_ClassInfo::operator delete (void* p)
{
  OMS_Globals::m_sharedMemAllocatorInstance.deallocate(p);
}

#endif

/*----------------------------------------------------------------------------------*/

void OMS_ClassInfo::Dump (OMS_ClassDumpInfo& dumpInfo)
{
  dumpInfo.m_addr           = this;
  dumpInfo.m_guid           = m_guid;
  dumpInfo.m_pBaseClass     = CONST_CAST(OMS_ClassInfo*, m_pBaseClass);
  memset(&dumpInfo.m_ClassName[0], ' ', sizeof(dumpInfo.m_ClassName));
  memcpy(&dumpInfo.m_ClassName[0], &m_ClassName[0], strlen(m_ClassName));
  dumpInfo.m_ObjectSize     = (tsp00_Int4) m_ObjectSize;
  dumpInfo.m_VTBLPtr        = m_VTPtr;
  dumpInfo.m_isBaseClass    = m_isBaseClass;
  dumpInfo.m_isDerivedClass = m_isDerivedClass;
  dumpInfo.m_isVarObject    = m_isVarObject;
  dumpInfo.m_filler         = 0;
}

