#ifndef __OMS_CACHEMISSENTRYDEF_HPP
#define __OMS_CACHEMISSENTRYDEF_HPP

#include "Oms/OMS_Defines.h"

class OMS_Context;

class OMS_CacheMissEntry {   // PTS 1117571
public:
  int             m_keyLen;
  // Attention! m_key must be the last member in the declaration list.
  //   As the key-length is unknown in advance, the necessary space is 
  //   allocated in the construktor and placed directly behind (and 'coalesced') 
  //   with the member m_key. Because m_key has already length 1, the additionally
  //   allocated space is one byte less than the keyLen. 
  unsigned char m_key[1];

  inline static void* operator new (size_t sz, int keyLen, OMS_Context* pContext);
#if defined(OMS_PLACEMENT_DELETE)
  inline static void  operator delete (void* p, int keyLen, OMS_Context* pContext);
#endif

  inline OMS_CacheMissEntry (const unsigned char*, int);
  inline ~OMS_CacheMissEntry ();
  inline void setKey(const unsigned char*, int);
  inline void deleteSelf (OMS_Context* pContext);
  inline int Compare(const OMS_CacheMissEntry*, const OMS_CacheMissEntry*);
};

//----------------------------------------------------------------------/

inline OMS_CacheMissEntry::OMS_CacheMissEntry (const unsigned char *key,     
                                               int                 keyLen)
{
  if (keyLen > 0){
    m_keyLen = keyLen;
  }
  else {
    m_keyLen = 0;
  }

  if (key != NULL){
    memcpy(&m_key, key, m_keyLen);
  }
  else {
    memset(&m_key, '\0', m_keyLen);   
  }
}

//----------------------------------------------------------------------/

inline OMS_CacheMissEntry::~OMS_CacheMissEntry ()
{
}

//----------------------------------------------------------------------/

inline int OMS_CacheMissEntry::Compare(const OMS_CacheMissEntry* l, 
                                         const OMS_CacheMissEntry* r) 
{
  int cmp = memcmp (l->m_key, r->m_key, m_keyLen);
  if (cmp) {
    return cmp > 0 ? 1 : -1;
  }
  else {
    return 0;
  }
}

#endif  // __OMS_CACHEMISSENTRYDEF_HPP