/*!
 * @file  Join_TableAccessOperator.cpp
 * @brief implements Join_TableAccessOperator
 *
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 * @sa Join_TableAccessOperator.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
#include "SAPDB/Join/Join_TableAccessOperator.hpp"
#include "SAPDB/Join/Join_AccessOperator.hpp"
#include "ggg00.h"
#include "ggg07.h"
#include "hbd02.h"
#include "hta01.h"
#include "hta01_3.h"
#include "SAPDB/Trace/Trace_Entry.hpp"
#include "Trace/Trace_MessBlockEntry.hpp"
#include "SAPDBCommon/SAPDB_Types.hpp"

/* ******************** PUBLIC MEMBERS ********************* */
/*!
 * @param acv [in] global context
 * @param buffersize [in] size of table buffer
 */
Join_TableAccessOperator::Join_TableAccessOperator(
        tak_all_command_glob& acv,
        SAPDB_Byte*        bufferPtr,
        const SAPDB_UInt4& buffersize)
    :
    Join_AccessOperator(acv, bufferPtr, buffersize),
    m_nextVirtualFile(false)
{}

/*************************************************************************/

void Join_TableAccessOperator::SelectRecords()
{
    SAPDBTRACE_METHOD_DEBUG(
        "Join_TableAccessOperatorBase::SelectRecords", Join_Trace, 1 );

    SAPDBTRACE_IF(
        Join_Trace, 5,
        t01surrogate( td_always, "sel TABID   ",
                      m_AccessDesc.FileIDs().file_id.fileTabId_gg00()));

    m_SelFields.sfp_m_result_cnt() = m_maxRowRequest; // set buffer count
    const SAPDB_Int4 recordsWanted = m_SelFields.sfp_m_result_cnt();
    SAPDB_Int4       recordsRead   = 0;
    tgg00_BasisError& bdState = m_AccessDesc.MBlock().mb_trns()->trError_gg00;
    do {
        pasbool           _unqualified;
        tgg00_LockReqMode _granted_lock;

        SAPDBTRACE_WRITELN(
            Join_Trace, 5,
            "records demanded: " << m_SelFields.sfp_m_result_cnt() << NewLine
            << "\treclen: " << m_SelFields.sfp_resrec_maxlen() );

        SAPDBTRACE_WRITELN(
            Join_Trace, 3,
            "keyLen: " << m_Actualkeys.reckey.len() << NewLine
            << "mess2_type: " << m_SelFields.sfp_bd_mess2_type() );
#ifdef SAPDB_SLOW
        t01buf( td_always, &m_Actualkeys.reckey.k(), 1, m_Actualkeys.reckey.len());
#endif
        b02kb_select_rec(
            *m_AccessDesc.MBlock().mb_trns(),
            m_AccessDesc.FileIDs().file_id,
            (tsp00_KeyPtr) &m_Actualkeys.reckey.k(),
            m_Actualkeys.reckey.len(),
            (tsp00_KeyPtr) &m_Stopkeys.reckey.k(),
            m_Stopkeys.reckey.len(),
            0 /*recsize*/, 0 /*recptr*/,
            false /* ignore_vwait*/,
            m_SelFields,
            m_AccessDesc.MBlock().mb_qual()->mstack_desc(),
            _unqualified,
            _granted_lock );

        recordsRead += m_SelFields.sfp_m_result_cnt();

        if ( (e_ok != bdState) && (e_no_next_record != bdState) )
            // error has occured
            break;

        if ( (recordsWanted != m_SelFields.sfp_m_result_cnt())
             && (e_ok == m_AccessDesc.MBlock().mb_trns()->trError_gg00) )
            // buffer full, possibly more records available
            break;

        if ( (1 == m_maxRowRequest)
             && (e_ok == m_AccessDesc.MBlock().mb_trns()->trError_gg00) )
        {
            // found one record, that is all we wanted
            m_AccessDesc.MBlock().mb_trns()->trError_gg00 = e_no_next_record;
            break;
        }

        if ( e_no_next_record == bdState )
        {
            // got all records from this file
            if ( m_AccessDesc.IsVirtualFile() )
            {
                SAPDBTRACE_WRITELN(
                    Join_Trace, 3, "switch to next recursive file" );
                m_AccessDesc.SetNextFileID();

                SAPDBTRACE_IF(
                    Join_Trace, 5,
                    t01treeid( td_always, "next treeid ",
                               m_AccessDesc.FileIDs().file_id));
                m_Actualkeys = m_Startkeys;
                m_SelFields.sfp_bd_mess_type().becomes( m_select );
                m_SelFields.sfp_bd_mess2_type().becomes( mm_first );
                m_SelFields.sfp_m_result_cnt() = m_maxRowRequest;

                bdState = e_ok;
            }
            else
            {
                SAPDBTRACE_WRITELN( Join_Trace, 3, "file empty!" );
            }
        }
    } while ( e_no_next_record != bdState );

    SAPDBTRACE_WRITELN( Join_Trace, 5, "BD call: " << SAPDBTrace::BasisError(m_AccessDesc.MBlock().mb_trns()->trError_gg00) );

    m_SelFields.sfp_m_result_cnt() = recordsRead;

    if ( (e_buffer_limit == bdState)
         && (0 < m_SelFields.sfp_m_result_cnt()) ) {
        // a new virtual file was opened but no record fit in the
        // buffer any more
        bdState = e_ok;
    }
}

/* ******************* PROTECTED MEMBERS ******************* */


/* ******************** PRIVATE MEMBERS ******************** */
