#ifndef JOIN_RESULTSETAPPENDER_HPP
#define JOIN_RESULTSETAPPENDER_HPP
/*!
 * @file
 * @brief implements interface Join_IResultSetAppender
 *
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 * @sa Join_Execute.cpp, Join_IResultSetAppender.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
#include "SAPDB/Join/Join_IResultSetAppender.hpp"

//! implements interface Join_IResultSetAppender
class Join_ResultSetAppender : public Join_IResultSetAppender {
public:
    //! @name constructor / destructor
    //@{
    //! constructor
    /*! 
     * @param acv [in] global context
     * @param rec_desc [in] pointer to result record description
     * @param result_id [in] name of result file
     * @param rescnt [in] amount of records already in result set
     * @param maxrescnt [in] maximal amount of records in result set
     */
    Join_ResultSetAppender( 
            tak_all_command_glob&           acv, 
            const tgg00_StackList * const   rec_desc,
            tgg00_FileId&                   result_id, 
            const SAPDB_Int4&               rescnt,
            const SAPDB_Int4&               maxrescnt ) :
    Join_IResultSetAppender( acv, rec_desc, result_id, rescnt, maxrescnt )
    { 
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetAppender::ctor", Join_Trace, 1 );
    }
    //@}

    //! @name manipulation of result set
    //@{
    //! add record to result set
    /*!
     * @param record [in] record to be added
     * @return information code <tt>[e_ok, e_no_next_record]</tt> / error code
     */
    virtual tgg00_BasisError Add( tgg00_Rec& record )
    {
        SAPDBTRACE_METHOD_DEBUG( "Join_ResultSetAppender::Add", Join_Trace, 1 );
        if ( m_ResultCnt < m_MaxResultCnt )
        {
            return add( record );
        }
        return e_no_next_record;
    }
    //@}
};

#endif // JOIN_RESULTSETAPPENDER_HPP
