/*!
 * @file  Join_IAccessOperator
 * @brief implements Join_IAccessOperator
 *
 * @author GertG
 * @ingroup Join
 *
 * @par last changed by:
 * <br>
 * $Author: d024980 $ $DateTime: 2004/05/03 16:16:26 $
 *
 * @sa Join_IAccessOperator.hpp
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

#include "SAPDB/Join/Join_IAccessOperator.hpp"

#include "SAPDB/Trace/Trace_Entry.hpp"
#include "Trace/Trace_MessBlockEntry.hpp"
#include "SAPDBCommon/SAPDB_Types.hpp"
#include "ggg00.h"
#include "hgg01_3.h"
#include "ggg11.h"
#include "gsp00.h"


/* ******************** PUBLIC MEMBERS ********************* */
/*!
 * @param acv [in] global context
 */
Join_IAccessOperator::Join_IAccessOperator(
    tak_all_command_glob& acv)
    : IOperator(acv),
      m_AccessDesc(acv),
      m_maxRowRequest(SAPDB_MAX_INT4)
{
    SAPDBTRACE_METHOD_DEBUG( "Join_IAccessOperator::ctor", Join_Trace, 1 );

    SAPDBTRACE_WRITELN(
        Join_Trace, 5,
        "\nstrat reclen: " << GetRecordLength() );

    if ( g01vtrace.vtrAll_gg00 )
    {
        // tracing
        tgg11_KbTabKeyTrace _mess_trace;
        _mess_trace.kbtkTabHead_gg11.kbtHead_gg11.kbMessType_gg11  =
            m_AccessDesc.MBlock().mb_type();
        _mess_trace.kbtkTabHead_gg11.kbtHead_gg11.kbMessType2_gg11 =
            m_AccessDesc.MBlock().mb_type2();
        _mess_trace.kbtkTabHead_gg11.kbtHead_gg11.kbSubtrans_gg11 =
            m_AccessDesc.MBlock().mb_trns()->trSubtransId_gg00;
        _mess_trace.kbtkTabHead_gg11.kbtTabId_gg11 =
            m_AccessDesc.MBlock().mb_qual()->mtree().fileTabId_gg00();
        _mess_trace.kbtkTabHead_gg11.kbtKeyLen_gg11 = 0;
        SAPDB_UInt4 __len = sizeof( _mess_trace.kbtkTabHead_gg11 );
        if ( m_AccessDesc.MBlock().mb_trns()->trError_gg00 != e_move_error )
        {
            Trace_CommonEntry Entry(
                *m_AccessDesc.MBlock().mb_trns(),
                tgg00_Debug::fromConst(kb),
                tgg00_VtraceType::fromConst(vttKbFunctions_egg00),
                (tsp00_BytePtr) &_mess_trace, __len );
        }
    }

    if ( Join_Trace.TracesLevel( 1 ) )
    {
        tgg00_Debug Layer = tgg00_Debug::fromConst( ak_messbuf );

        Trace_MessBlockEntry Entry(
            m_acv.a_transinf.tri_trans, m_acv.a_mblock, Layer,
            tgg00_VtraceType::fromConst(ak_send) );
    }

    invalidate_keys();
}

/*************************************************************************/

void Join_IAccessOperator::SetMaximumRowsReadAtATime(
    const SAPDB_Int4 maxRowRequest)
{
    m_maxRowRequest = maxRowRequest;
}

/*************************************************************************/

SAPDB_Int4 Join_IAccessOperator::GetMaximumRowsReadAtATime() const
{
    return m_maxRowRequest;
}

/*************************************************************************/
