/*!
  @file           IFRUtil_Stream.h
  @author         D030044
  @ingroup        IFR_Util
  @brief          Implements a class for data streams
  @see            

\if EMIT_LICENCE



    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end






\endif
*/
#ifndef IFRUTIL_STREAM_H
#define IFRUTIL_STREAM_H

#include "Interfaces/Runtime/IFR_ErrorHndl.h"

/*!
  @class IFRUtil_Stream
  @brief Base class for data streams
  @ingroup IFR_Util
 */
class IFRUtil_Stream 
{
public:
  virtual int read (char *readBuf, int readLen) = 0;
};

/*!
  EndClass: IFRUtil_Stream
 */

/*!
  @class IFRUtil_IStream
  @brief Class for handling of input data streams
  @ingroup IFR_Util
 */
class IFRUtil_IStream : public IFRUtil_Stream
{
public:
  /**
   * @brief Constructor.
   * @param data Pointer to the data
   * @param len Length of the data
   */
  IFRUtil_IStream (char *data, int len);

  /**
   * @brief Reads from the input stream.
   * @param readBuf The buffer the read data has to be stored
   * @param readLen The length of the stream data to be read
   * @return The length read from the stream
   */
  int read (char *readBuf, int readLen);

private:
  char *m_data;           //!< The pointer to the stream data
  int m_currentPos;       //!< The current position within the stream
  int m_len;              //!< The length of the stream data
};

/*!
  EndClass: IFRUtil_IStream
 */

#endif // IFRUTIL_STREAM_H
