# ------------------------------------------------------------------------------
#
# LiveCache Kernel-side Library Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#


regex(.*\.cpp$)    -except -DOMS_IMPLEMENTATION

# -------------------------------------------------------------------------------------
# auxiliary structures:
# -------------------------------------------------------------------------------------
LVC_Messages.genmsg                 ascii

LVC_ErrorTraceObject.hpp            inc=ggg00,ggg12,ggg92.h,hgg01.h,Trace_Entry.hpp

LVC_HistoryNode.hpp                 inc=ggg00,gbd00,hbd13.h 

LVC_Messages.hpp                    inc=SAPDBErr_MessageList.hpp

LVC_Types.hpp                       inc=gbd900.h,SAPDBErr_MessageList.hpp

LVC_KeyOIdQueue.hpp                 inc=ggg92.h

LVC_ObjKeyIterator.hpp              inc=gbd300.h,gbd500.h,gbd510.h,gbd600.h,\
                                        ggg00,ggg92.h

LVC_AbstractObjKeyIterator.hpp      inc=SAPDBMem_IRawAllocator.hpp

LVC_SingleFileObjKeyIterator.hpp    inc=LVC_AbstractObjKeyIterator.hpp,\
                                        SAPDBMem_IRawAllocator.hpp,\
                                        LVC_KeyOIdQueue.hpp

LVC_MultiFileObjKeyIterator.hpp     inc=ggg200.h,ggg92.h,\
                                        LVC_AbstractObjKeyIterator.hpp,\
                                        LVC_BufferedObjKeyIterator.hpp,\
                                        SAPDBMem_NewDestroy.hpp

LVC_WaitForDelObjFileQueue.hpp      inc=ggg00,\
                                        heo55k.h,\
 										heo56.h,\
                                        SAPDB_Types.hpp,\
 										RTEMem_Allocator.hpp

LVC_BufferedObjKeyIterator.hpp      inc=SAPDBMem_IRawAllocator.hpp,\
                                        LVC_KeyOIdQueue.hpp

LVC_LibOmsInterface.hpp             inc=OMS_LibOmsInterface.hpp

LVC_KernelInterface.hpp             inc=gsp00,RTEMem_AllocatorRegister.hpp

LVC_KernelInterfaceInstance.hpp     inc=LVC_KernelInterface.hpp,LVC_LockRequest.hpp,LVC_RWLockManager.hpp

LVC_RWLockManager.hpp               inc=RTESync_RWRegion.hpp,RTESync_Spinlock.hpp
LVC_RWLockManager.cpp               inc=LVC_RWLockManager.hpp,LVC_LockRequest.hpp

LVC_SingleFileObjKeyIterator.cpp    inc=gbd900.h,hbd03.h,\
                                        RTE_Message.hpp,\
                                        LVC_SingleFileObjKeyIterator.hpp,\
                                        LVC_ObjKeyIterator.hpp,\
                                        LVC_Messages.hpp,\
                                        LVC_Types.hpp
                                        
LVC_BufferedObjKeyIterator.cpp      inc=gbd900.h,hbd03.h,\
                                        RTE_Message.hpp,\
                                        LVC_BufferedObjKeyIterator.hpp,\
                                        LVC_ObjKeyIterator.hpp,\
                                        LVC_Messages.hpp,\
                                        LVC_Types.hpp
                                        

LVC_KernelInterfaceInstance.cpp     inc=LVC_KernelInterfaceInstance.hpp,\
                                        LVCMem_Wrapper.hpp,\
                                        SAPDBMem_NewDestroy.hpp,\
                                        LVCMem_Allocator.hpp,\
                                        OMS_StackTraceCallbackInterface.hpp,\
                                        RTESys_MicroTime.h,RTEMem_RteAllocator.hpp,hsp77.h,\
                                        vak001,hgg11.h,heo52.h,heo56.h,heo58.h,hgg01.h,hgg01_3.h,geo573.h,\
                                        heo51.h,heo670.h,Kernel_OpMsg.hpp


LVC_LibOmsInterface.cpp             inc=LVC_LibOmsInterface.hpp

LVC_NewObjectChecker.hpp            inc=ggg250.h

LVC_IliveCacheSink.hpp              inc=LVC_MethodNames.hpp,OMS_Defines.h,geo00.h,ggg00,ggg01,\
                                    OMS_IterDirection.hpp, \
                                    dep=OMS_LiveCacheTypes.idl


LVC_DispatcherHashEntry.hpp         inc=OMS_Defines.h,gsp00
LVC_DispatcherHashEntry.cpp         inc=LVC_DispatcherHashEntry.hpp

LVC_DispatcherCOMClassHash.hpp      inc=LVC_DispatcherHashEntry.hpp
LVC_DispatcherCOMClassHash.cpp      inc=LVC_DispatcherCOMClassHash.hpp

LVC_Dispatcher.hpp                  inc=Container_Hash.hpp,LVC_DispatcherCOMClassHash.hpp,\
&if $OSSPEC = WIN32
                                    gos00.h,\
&else
                                    gen00.h,\
&endif
                                    RTESync_Spinlock.hpp,vak001 dep=OMS_IliveCacheSpec.idl
LVC_Dispatcher.cpp                  inc=LVC_Dispatcher.hpp,RTESys_SharedLib.h,RTE_Message.hpp,\
                                    LVC_DispatcherVTable.hpp,SAPDBMem_IRawAllocator.hpp,\
                                    OMS_CallbackInterface.hpp,OMS_DbpError.hpp,hsp77.h,\
                                    LVC_LoadComponentLibrary.hpp,hgg01_3.h,\
                                    geo00d.h,geo007_1.h,heo38.h,\
                                    heo01.h,vak001,geo38.h,geo573.h,hgg01_3.h,hak263.h

LVC_InProcDispatcher.hpp            inc=LVC_Dispatcher.hpp,ggg91.h,heo52.h
LVC_InProcDispatcher.cpp            inc=LVC_InProcDispatcher.hpp,LVC_ProcServerExtender.hpp,\
                                    LVCMem_Allocator.hpp,LVC_DispatcherParams.hpp,\
                                    RTESync_Spinlock.hpp,OMS_DbpError.hpp,\
                                    LVC_LoadComponentLibrary.hpp,LVC_LoadLibrary.hpp,\
                                    SAPDB_UTF8Basis.hpp,hgg01_3.h,\
                                    heo38.h,geo60.h,hsp77.h,\
                                    geo00d.h,geo50_0.h,geo007_1.h,hgg08.h,\
                                    heo55k.h,heo52.h,heo58.h,heo15.h,heo01.h,\
                                    gsp92,heo922.h,hgg01.h,heo52.h,hgg01_3.h,hsp78_0.h\
&if $OSSPEC = WIN32
                                    ,hos38.h
&else
                                    ,hen50.h
&endif

LVC_DispatcherParams.hpp            inc=OMS_Defines.h,gsp00,hsp26.h
LVC_DispatcherParams.cpp            inc=LVC_DispatcherParams.hpp,LVC_LoadComponentLibrary.hpp,\
                                    geo00d.h,vak001,geo60.h,geo007_1.h

LVC_ProcServerInterface.hpp         inc=OMS_Defines.h,OMS_DbpError.hpp,gsp00,ggg00,ggg01,ggg91.h
LVC_ProcServerInterface.cpp         inc=LVC_ProcServerInterface.hpp,LVC_ProcServerExecutor.hpp,\
                                    SAPDBMem_RawAllocator.hpp

LVC_ProcServerExecutor.hpp          inc=LVC_ProcServerInterface.hpp
LVC_ProcServerExecutor.cpp          inc=LVC_ProcServerExecutor.hpp,vak001,LVCPS_PacketConsoleMsg.hpp,\
                                    LVCPS_PacketSingleObj.hpp,LVCPS_PacketContainer.hpp,\
                                    LVCPS_PacketVersion.hpp,LVCPS_PacketSchema.hpp,\
                                    LVCPS_PacketRegion.hpp,LVCPS_PacketSubtrans.hpp,\
                                    LVCPS_PacketConsistentView.hpp,LVCPS_PacketMassObj.hpp,\
                                    LVCPS_PacketIterator.hpp,LVCPS_PacketSequence.hpp,\
                                    LVCPS_PacketFile.hpp,LVCPS_PacketFile.hpp,\
                                    LVCPS_PacketABAPStream.hpp,LVCPS_PacketTasking.hpp,\
                                    LVCPS_PacketSQL.hpp,LVCPS_PacketVersionDict.hpp


LVC_ProcServerExtender.hpp          inc=LVC_ProcServerInterface.hpp,LVC_Dispatcher.hpp,\
                                    LVC_ProcServerExecutor.hpp,OMS_DbpBase.hpp,\
                                    OMS_DbpGlobals.hpp,geo38.h
LVC_ProcServerExtender.cpp          inc=LVC_ProcServerExtender.hpp,hsp77.h

LVC_LoadComponentLibrary.hpp        inc=gsp00,OMS_Defines.h
LVC_LoadComponentLibrary.cpp        inc=LVC_LoadComponentLibrary.hpp,geo00d.h,gip00.h,hgg11.h,\
                                    LVC_LoadLibrary.hpp,SAPDBAlgo_MD5File.h,heo02x.h,geo573.h,\
                                    OMS_DbpError.hpp

LVC_LoadLibrary.hpp                 inc=heo02x.h
LVC_LoadLibrary.cpp                 inc=LVC_LoadLibrary.hpp,LVC_Dispatcher.hpp,\
                                    OMS_DbpError.hpp,ggg251.h,ggg00,ggg01,geo007_1.h,\
                                    geo60.h,hsp77.h

&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

