/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbcext.ClientConnectionSapDB;
import com.sap.dbtech.jdbcext.ConnectionListenerBag;
import java.lang.ref.WeakReference;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.PooledConnection;

public class PooledConnectionSapDB
extends ConnectionListenerBag
implements PooledConnection {
    Connection physicalConnection;
    WeakReference lastClientConnection;

    PooledConnectionSapDB(Connection connection) {
        this.physicalConnection = connection;
        this.lastClientConnection = null;
    }

    private void sendErrorEvent(SQLException sQLException) {
        super.sendErrorEvent(this, sQLException);
    }

    private void sendCloseEvent() {
        super.sendCloseEvent(this);
    }

    private PooledConnectionSapDB self() {
        return this;
    }

    public synchronized Connection getConnection() throws SQLException {
        PooledClientConnectionSapDB pooledClientConnectionSapDB;
        Object var1_1 = null;
        if (this.lastClientConnection != null) {
            Object t = this.lastClientConnection.get();
            var1_1 = t;
            if (t != null) {
                pooledClientConnectionSapDB = var1_1;
                ConnectionSapDB connectionSapDB = null;
                try {
                    connectionSapDB = (ConnectionSapDB)this.physicalConnection;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                int n = pooledClientConnectionSapDB.statementContainer.size();
                for (int i = 0; i < n; ++i) {
                    StatementSapDB statementSapDB = (StatementSapDB)((WeakReference)pooledClientConnectionSapDB.statementContainer.get(i)).get();
                    if (statementSapDB == null) continue;
                    statementSapDB.close();
                }
                if (connectionSapDB != null) {
                    connectionSapDB.reinitialize();
                }
                pooledClientConnectionSapDB.rollback();
                pooledClientConnectionSapDB.closed = true;
            }
        }
        pooledClientConnectionSapDB = new PooledClientConnectionSapDB();
        this.lastClientConnection = new WeakReference<PooledClientConnectionSapDB>(pooledClientConnectionSapDB);
        return pooledClientConnectionSapDB;
    }

    public synchronized void close() throws SQLException {
        this.physicalConnection.close();
    }

    private class PooledClientConnectionSapDB
    extends ClientConnectionSapDB {
        boolean closed = false;
        ArrayList statementContainer = new ArrayList();

        private PooledClientConnectionSapDB() {
        }

        public Connection getPhysicalConnection() {
            return PooledConnectionSapDB.this.physicalConnection;
        }

        public void exceptionOccurred(SQLException sQLException) {
            if (sQLException instanceof SQLExceptionSapDB) {
                SQLExceptionSapDB sQLExceptionSapDB = (SQLExceptionSapDB)sQLException;
                if (sQLExceptionSapDB.isConnectionReleasing()) {
                    PooledConnectionSapDB.this.sendErrorEvent(sQLException);
                }
            } else {
                PooledConnectionSapDB.this.sendErrorEvent(sQLException);
            }
        }

        private ConnectionSapDB getSapDBConnection(Connection connection) {
            ConnectionSapDB connectionSapDB = null;
            try {
                connectionSapDB = (ConnectionSapDB)PooledConnectionSapDB.this.physicalConnection;
                return connectionSapDB;
            }
            catch (ClassCastException classCastException) {
                try {
                    com.sap.dbtech.jdbc.trace.Connection connection2 = (com.sap.dbtech.jdbc.trace.Connection)PooledConnectionSapDB.this.physicalConnection;
                    connectionSapDB = (ConnectionSapDB)connection2.getInner();
                    return connectionSapDB;
                }
                catch (ClassCastException classCastException2) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            if (this.closed) {
                return;
            }
            PooledConnectionSapDB pooledConnectionSapDB = PooledConnectionSapDB.this.self();
            synchronized (pooledConnectionSapDB) {
                int n = this.statementContainer.size();
                for (int i = 0; i < n; ++i) {
                    StatementSapDB statementSapDB = (StatementSapDB)((WeakReference)this.statementContainer.get(i)).get();
                    if (statementSapDB == null) continue;
                    statementSapDB.close();
                }
                ConnectionSapDB connectionSapDB = this.getSapDBConnection(PooledConnectionSapDB.this.physicalConnection);
                if (connectionSapDB != null) {
                    connectionSapDB.reinitialize();
                }
                if (!this.getAutoCommit()) {
                    this.rollback();
                }
                this.closed = true;
                PooledConnectionSapDB.this.sendCloseEvent();
            }
        }

        public boolean isClosed() throws SQLException {
            if (this.closed) {
                return true;
            }
            return super.isClosed();
        }

        public void finalize() {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add2StatementContainer(Object object) {
            ArrayList arrayList = this.statementContainer;
            synchronized (arrayList) {
                this.statementContainer.add(new WeakReference<Object>(object));
            }
        }

        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            PreparedStatement preparedStatement = super.prepareStatement(string, n);
            this.add2StatementContainer(preparedStatement);
            return preparedStatement;
        }

        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            PreparedStatement preparedStatement = super.prepareStatement(string, nArray);
            this.add2StatementContainer(preparedStatement);
            return preparedStatement;
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            PreparedStatement preparedStatement = super.prepareStatement(string);
            this.add2StatementContainer(preparedStatement);
            return preparedStatement;
        }

        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            PreparedStatement preparedStatement = super.prepareStatement(string, n, n2, n3);
            this.add2StatementContainer(preparedStatement);
            return preparedStatement;
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            PreparedStatement preparedStatement = super.prepareStatement(string, n, n2);
            this.add2StatementContainer(preparedStatement);
            return preparedStatement;
        }

        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            PreparedStatement preparedStatement = super.prepareStatement(string, stringArray);
            this.add2StatementContainer(preparedStatement);
            return preparedStatement;
        }

        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            CallableStatement callableStatement = super.prepareCall(string, n, n2, n3);
            this.add2StatementContainer(callableStatement);
            return callableStatement;
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            CallableStatement callableStatement = super.prepareCall(string);
            this.add2StatementContainer(callableStatement);
            return callableStatement;
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            CallableStatement callableStatement = super.prepareCall(string, n, n2);
            this.add2StatementContainer(callableStatement);
            return callableStatement;
        }

        public Statement createStatement() throws SQLException {
            Statement statement = super.createStatement();
            this.add2StatementContainer(statement);
            return statement;
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            Statement statement = super.createStatement(n, n2);
            this.add2StatementContainer(statement);
            return statement;
        }

        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            Statement statement = super.createStatement(n, n2, n3);
            this.add2StatementContainer(statement);
            return statement;
        }
    }
}

