(**************************************************************************)
(*       ___                                                              *)
(*      ||M||                                                             *)
(*      ||A||       A project by Andrea Asperti                           *)
(*      ||T||                                                             *)
(*      ||I||       Developers:                                           *)
(*      ||T||         The HELM team.                                      *)
(*      ||A||         http://helm.cs.unibo.it                             *)
(*      \   /                                                             *)
(*       \ /        This file is distributed under the terms of the       *)
(*        v         GNU General Public License Version 2                  *)
(*                                                                        *)
(**************************************************************************)

include "logic/cprop_connectives.ma".

record powerset (A: Type) : Type ≝ { char: A → CProp }.

interpretation "powerset" 'powerset A = (powerset A).

interpretation "subset construction" 'subset \eta.x = (mk_powerset _ x).

definition mem ≝ λA.λS:Ω \sup A.λx:A. match S with [mk_powerset c ⇒ c x].

interpretation "mem" 'mem a S = (mem _ S a).

definition overlaps ≝ λA:Type.λU,V:Ω \sup A.exT2 ? (λa:A. a ∈ U) (λa.a ∈ V).

interpretation "overlaps" 'overlaps U V = (overlaps _ U V).

definition subseteq ≝ λA:Type.λU,V:Ω \sup A.∀a:A. a ∈ U → a ∈ V.

interpretation "subseteq" 'subseteq U V = (subseteq _ U V).

definition intersects ≝ λA:Type.λU,V:Ω \sup A.{a | a ∈ U ∧ a ∈ V}.

interpretation "intersects" 'intersects U V = (intersects _ U V).

definition union ≝ λA:Type.λU,V:Ω \sup A.{a | a ∈ U ∨ a ∈ V}.

interpretation "union" 'union U V = (union _ U V).

include "logic/equality.ma".

definition singleton ≝ λA:Type.λa:A.{b | a=b}.

interpretation "singleton" 'singl a = (singleton _ a).
