(* Copyright (C) 2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

(* $Id: cicNotation2.ml 6144 2006-02-22 22:39:47Z zacchiro $ *)

let load_notation ~include_paths fname =
  let ic = open_in fname in
  let lexbuf = Ulexing.from_utf8_channel ic in
  let status = ref LexiconEngine.initial_status in
  try
   while true do
    status := fst (GrafiteParser.parse_statement ~include_paths lexbuf !status)
   done;
   assert false
  with End_of_file -> close_in ic; !status

let parse_environment ~include_paths str =
 let lexbuf = Ulexing.from_utf8_string str in
 let status = ref LexiconEngine.initial_status in
 try
  while true do
   status := fst (GrafiteParser.parse_statement ~include_paths lexbuf !status)
  done;
  assert false
 with End_of_file ->
  !status.LexiconEngine.aliases,
  !status.LexiconEngine.multi_aliases
