/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


/////////////////////// Local includes
#include "mzLabOutputOligomerTreeViewItem.hpp"
#include "application.hpp"


namespace massXpert
{

  MzLabOutputOligomerTreeViewItem::MzLabOutputOligomerTreeViewItem 
 (const QList<QVariant> &data,
   MzLabOutputOligomerTreeViewItem *parent)
  {
    mp_parentItem = parent;
    m_itemData = data;
    mp_oligomerPair = 0;
  }


  MzLabOutputOligomerTreeViewItem::~MzLabOutputOligomerTreeViewItem()
  {
    qDeleteAll(m_childItemsList);
  }


  MzLabOutputOligomerTreeViewItem *
  MzLabOutputOligomerTreeViewItem::parent()
  {
    return mp_parentItem;
  }


  void 
  MzLabOutputOligomerTreeViewItem::appendChild(MzLabOutputOligomerTreeViewItem *
					   item)
  {
    m_childItemsList.append(item);
  }


  void 
  MzLabOutputOligomerTreeViewItem::insertChild(int index,
					   MzLabOutputOligomerTreeViewItem *item)
  {
    m_childItemsList.insert(index, item);
  }


  MzLabOutputOligomerTreeViewItem *
  MzLabOutputOligomerTreeViewItem::child(int row)
  {
    return m_childItemsList.value(row);
  }


  MzLabOutputOligomerTreeViewItem *
  MzLabOutputOligomerTreeViewItem::takeChild(int row)
  {
    MzLabOutputOligomerTreeViewItem *item = m_childItemsList.takeAt(row);
  
    return item;
  }


  const QList<MzLabOutputOligomerTreeViewItem *> &
  MzLabOutputOligomerTreeViewItem::childItems()
  {
    return m_childItemsList;
  }



  int 
  MzLabOutputOligomerTreeViewItem::childCount() const
  {
    return m_childItemsList.count();
  }


  int 
  MzLabOutputOligomerTreeViewItem::columnCount() const
  {
    return m_itemData.count();
  }


  QVariant 
  MzLabOutputOligomerTreeViewItem::data(int column) const
  {
    return m_itemData.value(column);
  }


  bool 
  MzLabOutputOligomerTreeViewItem::setData(int column, const QVariant & value)
  {
    m_itemData [column].setValue(value.toString());

    return true;
  }

  
  int
  MzLabOutputOligomerTreeViewItem::row() const
  {
    if (mp_parentItem != 0)
      return mp_parentItem->
	m_childItemsList.indexOf 
	(const_cast<MzLabOutputOligomerTreeViewItem *>(this));
  
    return 0;
  }


  void
  MzLabOutputOligomerTreeViewItem::setOligomerPair(OligomerPair *oligomerPair)
  {
    Q_ASSERT(oligomerPair);
    mp_oligomerPair = oligomerPair;
  }


  OligomerPair *
  MzLabOutputOligomerTreeViewItem::oligomerPair()
  {
    return mp_oligomerPair;
  }

} // namespace massXpert
