/* massXpert - the true massist's program.
   --------------------------------------
   Copyright(C) 2006,2007 Filippo Rusconi

   http://www.massxpert.org/massXpert

   This file is part of the massXpert project.

   The massxpert project is the successor to the "GNU polyxmass"
   project that is an official GNU project package(see
   www.gnu.org). The massXpert project is not endorsed by the GNU
   project, although it is released ---in its entirety--- under the
   GNU General Public License. A huge part of the code in massXpert
   is actually a C++ rewrite of code in GNU polyxmass. As such
   massXpert was started at the Centre National de la Recherche
   Scientifique(FRANCE), that granted me the formal authorization to
   publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License version 3, as published by the Free Software Foundation.
   

   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software; if not, write to the

   Free Software Foundation, Inc.,

   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/


/////////////////////// Local includes
#include "mzLabOutputOligomerTreeViewModel.hpp"
#include "mzLabOutputOligomerTreeViewDlg.hpp"
#include "globals.hpp"
#include "application.hpp"


namespace massXpert
{

  MzLabOutputOligomerTreeViewModel::MzLabOutputOligomerTreeViewModel 
 (QList <OligomerPair *> *dataList, QObject *parent) 
    : QAbstractItemModel(parent)
  {
    QList<QVariant> rootData;

    Q_ASSERT(dataList);
    Q_ASSERT(parent);
  
    mp_parentDlg = static_cast<MzLabOutputOligomerTreeViewDlg *>(parent);

    rootData << tr("m/z 1") << tr("z 1")
	     << tr("m/z 2") << tr("z 2")
	     << tr("Error");

    mp_oligomerPairList = 0;

    mpa_rootItem = new MzLabOutputOligomerTreeViewItem(rootData);
      
    mp_oligomerPairList = dataList;
    setupModelData(mpa_rootItem);
  }


  MzLabOutputOligomerTreeViewModel::~MzLabOutputOligomerTreeViewModel()
  {
    delete mpa_rootItem;
  }


  void
  MzLabOutputOligomerTreeViewModel::setParentDlg(MzLabOutputOligomerTreeViewDlg *dlg)
  {
    mp_parentDlg = dlg;
  }
  
  
  MzLabOutputOligomerTreeViewDlg *
  MzLabOutputOligomerTreeViewModel::getParentDlg()
  {
    return mp_parentDlg;
  }
  
  
  void
  MzLabOutputOligomerTreeViewModel::setMzLabWnd(MzLabWnd *wnd)
  {
    mp_mzLabWnd = wnd;
  }
  
  
  MzLabWnd *
  MzLabOutputOligomerTreeViewModel::getMzLabWnd()
  {
    return mp_mzLabWnd;
  }
  
  
  void 
  MzLabOutputOligomerTreeViewModel::setTreeView(QTreeView *treeView)
  {
    Q_ASSERT(treeView);
  
    mp_treeView = treeView;
  }


  QTreeView *
  MzLabOutputOligomerTreeViewModel::treeView()
  {
    return mp_treeView;
  }


  QVariant 
  MzLabOutputOligomerTreeViewModel::data(const QModelIndex &index, 
				     int role) const
  {
    if (!index.isValid())
      return QVariant();
  
    if (role != Qt::DisplayRole)
      return QVariant();
  
    MzLabOutputOligomerTreeViewItem *item = 
      static_cast<MzLabOutputOligomerTreeViewItem *>(index.internalPointer());
  
    return item->data(index.column());
  }


  void
  MzLabOutputOligomerTreeViewModel::addOligomerPair(OligomerPair *oligomerPair)
  {
    Q_ASSERT(oligomerPair);
  }
  
  
  bool
  MzLabOutputOligomerTreeViewModel::setData(const QModelIndex &index, 
					     const QVariant & value, 
					     int role)
  {
    return QAbstractItemModel::setData(index, value, role);
  }


  QVariant 
  MzLabOutputOligomerTreeViewModel::headerData(int section, 
					   Qt::Orientation orientation,
					   int role) const
  {
    if (orientation == Qt::Horizontal && role == Qt::DisplayRole)
      return mpa_rootItem->data(section);
  
    return QVariant();
  }


  Qt::ItemFlags 
  MzLabOutputOligomerTreeViewModel::flags(const QModelIndex &index) const
  {
    // We want to be able to drop stuff on items.
    Qt::ItemFlags defaultFlags = QAbstractItemModel::flags(index);
    
    if (index.isValid())
      return Qt::ItemIsDropEnabled | defaultFlags;
    else
      return Qt::ItemIsDropEnabled | defaultFlags;
  }
  
  
  QModelIndex 
  MzLabOutputOligomerTreeViewModel::index(int row, int column,
				      const QModelIndex &parent) const
  {
    MzLabOutputOligomerTreeViewItem *parentItem = 0;
  
    if (!parent.isValid())
      parentItem = mpa_rootItem;
    else
      parentItem = 
	static_cast<MzLabOutputOligomerTreeViewItem *> 
	(parent.internalPointer());
  
    MzLabOutputOligomerTreeViewItem *childItem = parentItem->child(row);
    if (childItem)
      return createIndex(row, column, childItem);
    else
      return QModelIndex();
  }


  QModelIndex 
  MzLabOutputOligomerTreeViewModel::parent(const QModelIndex &index) const
  {
    if (!index.isValid())
      return QModelIndex();

    MzLabOutputOligomerTreeViewItem *childItem = 
      static_cast<MzLabOutputOligomerTreeViewItem *>(index.internalPointer());
  
    MzLabOutputOligomerTreeViewItem *parentItem = childItem->parent();

    if (parentItem == mpa_rootItem)
      return QModelIndex();
  
    return createIndex(parentItem->row(), 0, parentItem);
  }


  int 
  MzLabOutputOligomerTreeViewModel::rowCount(const QModelIndex &parent) const
  {
    MzLabOutputOligomerTreeViewItem *parentItem;
  
    if (!parent.isValid())
      parentItem = mpa_rootItem;
    else
      parentItem = 
	static_cast<MzLabOutputOligomerTreeViewItem *> 
	(parent.internalPointer());
  
    return parentItem->childCount();
  }


  int
  MzLabOutputOligomerTreeViewModel::columnCount(const QModelIndex &parent) const
  {
    if (parent.isValid())
      return static_cast<MzLabOutputOligomerTreeViewItem *> 
	(parent.internalPointer())->columnCount();
    else
      return mpa_rootItem->columnCount();
  }


  bool 
  MzLabOutputOligomerTreeViewModel::setupModelData(MzLabOutputOligomerTreeViewItem *parent)
  {
    Application *application = static_cast<Application *>(qApp);
    QLocale locale = application->locale();

    MzLabOutputOligomerTreeViewItem *currentItem = 0;
  
    OligomerPair *oligomerPair = 0;
  
    Q_ASSERT(parent);
  
  
    for (int iter = 0; iter < mp_oligomerPairList->size(); ++iter)
      {
	oligomerPair = mp_oligomerPairList->at(iter);
	
	QString mass1 = 
	  locale.toString(oligomerPair->mass1(), 'f', MXP_OLIGOMER_DEC_PLACES);
	
	QString mass2 = 
	  locale.toString(oligomerPair->mass2(), 'f', MXP_OLIGOMER_DEC_PLACES);
	
	QString error = 
	  locale.toString(oligomerPair->error(), 'f', MXP_OLIGOMER_DEC_PLACES);

	QList<QVariant> columnData;
	
	columnData  
	  << mass1 << oligomerPair->charge1()
	  << mass2 << oligomerPair->charge2()
	  << oligomerPair->error();
	
// 	qDebug() << __FILE__ << __LINE__ 
// 		 << "columnData:" << columnData;
	
	currentItem = 
	  new MzLabOutputOligomerTreeViewItem(columnData, parent);
	
	currentItem->setOligomerPair(oligomerPair);
	
	// Append the currently created item to the last partial.
	
	parent->appendChild(currentItem);
      }
    
    // At this point we have finished setting up the Model data.
    return true;
  }
  

} // namespace massXpert
