/*
            Manual Page Editor: Preferences & Options Window

	The Preferences & Options window holds the current preferences
	and options for the manual page editor.
 */

#ifndef PREF_H
#define PREF_H

#include <gtk/gtk.h>


/*
 *	Preference catagory values, each value is an index to a
 *	panel_parent on the Preferences & Options window structure
 */
#define MEDIT_PREF_CAT_APPERANCE		0
#define MEDIT_PREF_CAT_FONTS			1
#define MEDIT_PREF_CAT_COLORS			2

#define MEDIT_PREF_CAT_EDITOR			3

#define MEDIT_PREF_CAT_VIEWER			4

#define MEDIT_PREF_CAT_LOCATIONS		5
#define MEDIT_PREF_CAT_CONVERTERS		6


/*
 *	Parameter widget values, each value is an index to a
 *	parm_widget on the Preferences & Options window structure.
 */
#define MEDIT_PREF_PARM_STARTUP_EDITOR		0	/* GtkCheckButton */
#define MEDIT_PREF_PARM_STARTUP_VIEWER		1	/* GtkCheckButton */

#define MEDIT_PREF_PARM_RECORD_WIN_POS		2	/* GtkCheckButton */
#define MEDIT_PREF_PARM_TOOL_TIPS		3	/* GtkCheckButton */

#define MEDIT_PREF_PARM_TOOLBAR_PT		4	/* GtkRadioButton */
#define MEDIT_PREF_PARM_TOOLBAR_P		5	/* GtkRadioButton */
#define MEDIT_PREF_PARM_TOOLBAR_T		6	/* GtkRadioButton */

#define MEDIT_PREF_PARM_FONT_EDIT_STD		10	/* GtkEntry */
#define MEDIT_PREF_PARM_FONT_MANPAGE_STD	11	/* GtkEntry */
#define MEDIT_PREF_PARM_FONT_MANPAGE_BOLD	12	/* GtkEntry */
#define MEDIT_PREF_PARM_FONT_MANPAGE_UNDERLINE	13	/* GtkEntry */

#define MEDIT_PREF_PARM_COLOR_EDIT_TEXT_FG	20	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_EDIT_TEXT_BG	21	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_EDIT_TEXT_DELIM	22	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_EDIT_TEXT_TAG	23	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_EDIT_TEXT_SYMREP	24	/* GtkDrawingArea */

#define MEDIT_PREF_PARM_COLOR_MANPAGE_TEXT_FG	25	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_MANPAGE_TEXT_BG	26	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_MANPAGE_TEXT_BOLD	27	/* GtkDrawingArea */
#define MEDIT_PREF_PARM_COLOR_MANPAGE_TEXT_UNDERLINE	28	/* GtkDrawingArea */

#define MEDIT_PREF_PARM_EDITOR_ENABLE_SYNHL	30	/* GtkCheckButton */

#define MEDIT_PREF_PARM_LOCATIONS_RCFILE	40	/* GtkEntry */
#define MEDIT_PREF_PARM_LOCATIONS_GLOBAL_DIR	45	/* GtkEntry */
#define MEDIT_PREF_PARM_LOCATIONS_TMP_DIR	46	/* GtkEntry */

#define MEDIT_PREF_PARM_LOCATIONS_MAN_DIRS	47	/* GtkCList */

#define MEDIT_PREF_PARM_CONVERTERS_MANPAGE_TO_OUTPUT	50	/* GtkEntry */




/*
 *	Branch item structure for Preferences & Options window's
 *	layout_ctree
 */
typedef struct {

	/* One of MEDIT_PREF_CAT_* or -1 for none */
	gint		catagory;

	/* Pointer back to Preferences & Options window structure */
	gpointer	pref_ptr;

} pref_item_struct;


/*
 *	Preferences & Options window structure:
 */
typedef struct {

	gboolean	initialized,
			map_state,
			has_changes,
			processing;
	gpointer	core_ptr;

	GtkWidget	*toplevel,
			*main_vbox;

	/* Main catagory ctree */
	GtkWidget	*catagory_ctree;
	GtkCTreeNode	*selected_branch;

	/* Parent to all panel parent vboxes */
	GtkWidget	*panel_toplevel;

	/* Array of vboxes which hold various widgets depending
	 * on which branch on the layout_ctree is selected
	 */
	GtkWidget	**panel_parent;
	gint total_panel_parents;

	/* Buttons */
	GtkWidget	*ok_btn,
			*apply_btn,
			*save_btn,
			*close_btn;

	/* Pointers to parameter widgets, each parameter widget holds
	 * a value (depending on widget type). The parameter widget
	 * is indexed by hard coded values defined by
	 * MEDIT_PREF_PARM_*.
	 */
	GtkWidget	**parm_widget;
	gint		total_parm_widgets;


	/* Other values that we're not recording on widgets */
	gint		last_editor_width,
			last_editor_height;
	gint		last_viewer_width,
			last_viewer_height;

	gchar		*last_opened_manpage_path;
	gchar		*last_saved_manpage_path;
	gchar		*last_opened_manage_view_path;

	/* Last selected item on MEDIT_PREF_PARM_LOCATIONS_MAN_DIRS */
	gint		selected_manpage_dirs_clist_item;

} pref_struct;


extern GtkWidget *PrefParmGetWidget(pref_struct *pref, gint parameter);
extern GtkWidget *PrefPanelGetWidget(pref_struct *pref, gint catagory);
extern gchar *PrefPanelGetBranchText(pref_struct *pref, GtkCTreeNode *branch);

extern gint PrefParmRecord(
	pref_struct *pref,
	gint parameter,		/* One of MEDIT_PREF_PARM_* */
	GtkWidget *w
);

extern gint PrefPanelRecord(
	pref_struct *pref,
	gint catagory,		/* One of MEDIT_PREF_CAT_ */
	GtkWidget *w		/* A vbox */
);

extern gpointer PrefParmGetValueP(
	pref_struct *pref,
	gint parameter		/* One of MEDIT_PREF_PARM_* */
);
extern gint PrefParmGetValueI(
        pref_struct *pref,
        gint parameter		/* One of MEDIT_PREF_PARM_* */
);
extern float PrefParmGetValueF(
        pref_struct *pref,
        gint parameter		/* One of MEDIT_PREF_PARM_* */
);
extern gboolean PrefParmGetValueB(
        pref_struct *pref,
        gint parameter		/* One of MEDIT_PREF_PARM_* */
);

extern void PrefBranchSetData(
        GtkCTree *ctree, GtkCTreeNode *branch,
        pref_item_struct *item_ptr, GtkDestroyNotify destroy
);
extern pref_item_struct *PrefBranchGetData(
        GtkCTree *ctree, GtkCTreeNode *branch
);
extern void PrefSetBusy(pref_struct *pref);
extern void PrefSetReady(pref_struct *pref);

extern GtkCTreeNode *PrefAddCatagoryBranch(
        pref_struct *pref,
        const char *catagory_name,
        GtkCTreeNode *parent,
        GtkCTreeNode *sibling,
        gboolean is_leaf,   
        GtkWidget *panel_vbox,
        gint catagory
);

extern pref_struct *PrefNew(gpointer core_ptr);
extern void PrefUpdateMenus(pref_struct *pref);
extern void PrefReset(pref_struct *pref, gboolean need_unmap);
extern void PrefMap(pref_struct *pref);
extern void PrefUnmap(pref_struct *pref);
extern void PrefDelete(pref_struct *pref);


#endif	/* PREF_H */
