/*
				Popup List
 */

#ifndef PULIST_H
#define PULIST_H

#include <gtk/gtk.h>

/*
 *	Popup Relative:
 *
 *	Indicates the type of relativity to the rel_widget.
 */
typedef enum {
	PULIST_RELATIVE_CENTER,
	PULIST_RELATIVE_UP,
	PULIST_RELATIVE_DOWN,
	PULIST_RELATIVE_ABOVE,
	PULIST_RELATIVE_BELOW
} pulist_relative;


/*
 *	Popup List:
 */
typedef struct {

	GtkWidget	*toplevel,
			*main_vbox,
			*scrolled_window,
			*vscrollbar,
			*hscrollbar,
			*clist,
			*shadow;

	GdkPixmap	*shadow_pm;

	GtkWidget	*map_widget;	/* Shared */

	/* GTK+ block loops level */
	gint		gtk_block_level;

	/* Copy of last value */
	gchar		*last_value;

	/* Marks that the first button_press_event was sent to the
	 * clist if TRUE. This member is set FALSE at the beginning of
	 * each call to PUListMapQuery()
	 */
	gboolean	initial_list_button_press_sent;

} pulist_struct;
#define PULIST(p)	((pulist_struct *)(p))


extern gpointer PUListGetDataFromValue(
	pulist_struct *list, const gchar *value
);
extern GtkWidget *PUListGetToplevel(pulist_struct *list);
extern GtkWidget *PUListGetCList(pulist_struct *list);

extern void PUListAddItem(
	pulist_struct *list, const gchar *value,
	gpointer client_data, GtkDestroyNotify destroy_cb
);
extern void PUListAddItemPixText(
	pulist_struct *list, const gchar *value,
	GdkPixmap *pixmap, GdkBitmap *mask,
	gpointer client_data, GtkDestroyNotify destroy_cb
);
extern void PUListClear(pulist_struct *list);

extern gint PUListGetSelectedLast(pulist_struct *list);
extern void PUListSelect(pulist_struct *list, gint row);
extern void PUListUnselectAll(pulist_struct *list);

extern gboolean PUListIsQuery(pulist_struct *list);
extern void PUListBreakQuery(pulist_struct *list);
extern const gchar *PUListMapQuery(
	pulist_struct *list,
	const gchar *value,		/* Initial value */
	gint lines_visible,		/* Can be -1 for default */
	pulist_relative relative,	/* One of PULIST_RELATIVE_* */
	GtkWidget *rel_widget,		/* Map relative to this widget */
	GtkWidget *map_widget		/* Widget that mapped this list */
);

extern pulist_struct *PUListNew(void);
extern void PUListDelete(pulist_struct *list);

extern GtkWidget *PUListNewMapButton(
	void (*map_cb)(GtkWidget *, gpointer),
	gpointer client_data
);
extern GtkWidget *PUListNewMapButtonArrow(
	gint arrow_type, gint shadow_type,
	void (*map_cb)(GtkWidget *, gpointer),
	gpointer client_data
);


#endif	/* PULIST_H */
