/*
               Manual Page Editor Core: Operations
 */

#ifndef MANEDITOP_H
#define MANEDITOP_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "manedit.h"
#include "aboutdialog.h"

extern about_dialog_struct *MEditAboutDialogNew(medit_core_struct *core_ptr);
extern GtkWidget *MEditCreateHelpMenu(
	medit_core_struct *core_ptr, void *accel_group
);
extern char *MEditCreateTempDir(medit_core_struct *core_ptr);
extern int MEditExecuteFmtBlock(
        medit_core_struct *core_ptr,
        const char *cmd,
        const char *filename,
        const char *options,
        const char *stdout_path,
        const char *stderr_path
);
extern int MEditDialogFromFile(
	medit_core_struct *core_ptr,
	const char *path
);
extern int MEditDoEmergencySave(medit_core_struct *core_ptr);
extern int MEditDoCrashRecovery(medit_core_struct *core_ptr);


#endif	/* MANEDITOP_H */
