/*
 *  The Mana Client
 *  Copyright (C) 2004-2009  The Mana World Development Team
 *  Copyright (C) 2009-2010  The Mana Developers
 *
 *  This file is part of The Mana Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "flooritem.h"

#include "graphics.h"
#include "item.h"
#include "map.h"

#include "resources/image.h"

FloorItem::FloorItem(int id,
                     int itemId,
                     int x,
                     int y,
                     Map *map):
    mId(id),
    mX(x),
    mY(y),
    mMap(map),
    mAlpha(1.0f)
{
    // Create a corresponding item instance
    mItem = new Item(itemId);

    // Add ourselves to the map
    mMapSprite = mMap->addSprite(this);
}

FloorItem::~FloorItem()
{
    // Remove ourselves from the map
    mMap->removeSprite(mMapSprite);

    delete mItem;
}

int FloorItem::getItemId() const
{
    return mItem->getId();
}

Item *FloorItem::getItem() const
{
    return mItem;
}

void FloorItem::draw(Graphics *graphics, int offsetX, int offsetY) const
{
    if (mItem)
    {
        Image *image = mItem->getDrawImage();

        if (image)
            if (mAlpha != image->getAlpha())
                image->setAlpha(mAlpha);

        graphics->drawImage(image, mX * mMap->getTileWidth() + offsetX,
                            mY * mMap->getTileHeight() + offsetY);
    }
}
