// license:BSD-3-Clause
// copyright-holders:Nigel Barnes
/**********************************************************************

    Logotron Sprite Board

**********************************************************************/


#ifndef MAME_BUS_BBC_1MHZBUS_SPRITE_H
#define MAME_BUS_BBC_1MHZBUS_SPRITE_H

#include "1mhzbus.h"
#include "video/tms9928a.h"


//**************************************************************************
//  TYPE DEFINITIONS
//**************************************************************************

class bbc_sprite_device:
	public device_t,
	public device_bbc_1mhzbus_interface
{
public:
	// construction/destruction
	bbc_sprite_device(const machine_config &mconfig, const char *tag, device_t *owner, uint32_t clock);

protected:
	// device-level overrides
	virtual void device_start() override;
	virtual void device_reset() override;

	// optional information overrides
	virtual void device_add_mconfig(machine_config &config) override;

	virtual DECLARE_READ8_MEMBER(fred_r) override;
	virtual DECLARE_WRITE8_MEMBER(fred_w) override;

private:
	required_device<tms9129_device> m_vdp;
};


// device type definition
DECLARE_DEVICE_TYPE(BBC_SPRITE, bbc_sprite_device);


#endif /* MAME_BUS_BBC_1MHZBUS_SPRITE_H */
