/* This file is part of Mailfromd.
   Copyright (C) 2007-2021 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "libmf.h"

const char *
mf_status_str(mf_status s)
{
	switch (s) {
	case mf_success:
		return "success";
		
	case mf_not_found:
		return "not_found";
		
	case mf_failure:
		return "failure";
		
	case mf_temp_failure:
		return "temp_failure";
		
	case mf_timeout:
		return "timeout";
	}
	return "UNKNOWN";
}

