/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-shell.h"

#include "mn-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "mn-shell.gob"

#include "config.h"
#include <glib/gi18n.h>
#include <eel/eel.h>
#include "mn-properties-dialog.h"
#include "mn-util.h"
#include "mn-conf.h"
#include "mn-mailboxes.h"
#include "mn-about-dialog.h"
#include "mn-mail-summary-popup.h"
#include "mn-standard-message-view.h"
#include "mn-compact-message-view.h"
#include "mn-message.h"
#include "mn-stock.h"

MNShell *mn_shell = NULL;

#line 44 "mn-shell.c"
static const GEnumValue _mn_shell_tooltip_mail_summary_values[] = {
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD", (char *)"standard" },
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT", (char *)"compact" },
	{ MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE, (char *)"MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE", (char *)"none" },
	{ 0, NULL, NULL }
};

GType
mn_shell_tooltip_mail_summary_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNShellTooltipMailSummary", _mn_shell_tooltip_mail_summary_values);
	return type;
}

/* self casting macros */
#define SELF(x) MN_SHELL(x)
#define SELF_CONST(x) MN_SHELL_CONST(x)
#define IS_SELF(x) MN_IS_SHELL(x)
#define TYPE_SELF MN_TYPE_SHELL
#define SELF_CLASS(x) MN_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) MN_SHELL_GET_CLASS(x)

/* self typedefs */
typedef MNShell Self;
typedef MNShellClass SelfClass;

/* here are local prototypes */
static void mn_shell_class_init (MNShellClass * c) G_GNUC_UNUSED;
static void mn_shell_init (MNShell * self) G_GNUC_UNUSED;
static void ___2_mn_shell_finalize (GObject * object) G_GNUC_UNUSED;
static void mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_init_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_always_display_icon_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_tooltip_mail_summary_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_notify_mail_summary_popup_enable_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_update_sensitivity (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_icon (MNShell * self) G_GNUC_UNUSED;
static void mn_shell_update_tooltip (MNShell * self) G_GNUC_UNUSED;
static int mn_shell_new_mailboxes_compare_cb (MNMailbox * a, MNMailbox * b) G_GNUC_UNUSED;
static GtkWidget * mn_shell_tooltip_section_new (GtkVBox ** vbox, const char * title) G_GNUC_UNUSED;
static void mn_shell_tooltip_text_section_new (GtkVBox ** vbox, const char * title, const char * text) G_GNUC_UNUSED;
static void mn_shell_update_popup (MNShell * self, gboolean has_new) G_GNUC_UNUSED;
static gboolean mn_shell_clean_popup_previous_messages_cb (const char * id, MNMessage * message, gpointer user_data) G_GNUC_UNUSED;
static void mn_shell_popup_weak_notify_cb (MNShell * self, GObject * former_object) G_GNUC_UNUSED;
static void mn_shell_display_window (MNShell * self, GType type, GtkWidget ** ptr) G_GNUC_UNUSED;
static void mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_messages_changed_h mn_shell_messages_changed_h
#define self_mailbox_removed_h mn_shell_mailbox_removed_h
#define self_init_icon mn_shell_init_icon
#define self_notify_blink_on_errors_cb mn_shell_notify_blink_on_errors_cb
#define self_notify_always_display_icon_cb mn_shell_notify_always_display_icon_cb
#define self_notify_mail_reader_cb mn_shell_notify_mail_reader_cb
#define self_notify_tooltip_mail_summary_cb mn_shell_notify_tooltip_mail_summary_cb
#define self_notify_mail_summary_popup_enable_cb mn_shell_notify_mail_summary_popup_enable_cb
#define self_icon_activate_h mn_shell_icon_activate_h
#define self_icon_activate_mail_reader_h mn_shell_icon_activate_mail_reader_h
#define self_icon_activate_update_h mn_shell_icon_activate_update_h
#define self_icon_activate_properties_h mn_shell_icon_activate_properties_h
#define self_icon_activate_help_h mn_shell_icon_activate_help_h
#define self_icon_activate_about_h mn_shell_icon_activate_about_h
#define self_icon_activate_remove_h mn_shell_icon_activate_remove_h
#define self_icon_destroy_h mn_shell_icon_destroy_h
#define self_update_sensitivity mn_shell_update_sensitivity
#define self_update_icon mn_shell_update_icon
#define self_update_tooltip mn_shell_update_tooltip
#define self_new_mailboxes_compare_cb mn_shell_new_mailboxes_compare_cb
#define self_tooltip_section_new mn_shell_tooltip_section_new
#define self_tooltip_text_section_new mn_shell_tooltip_text_section_new
#define self_update_popup mn_shell_update_popup
#define self_clean_popup_previous_messages_cb mn_shell_clean_popup_previous_messages_cb
#define self_popup_weak_notify_cb mn_shell_popup_weak_notify_cb
#define self_new mn_shell_new
#define self_display_properties_dialog mn_shell_display_properties_dialog
#define self_display_about_dialog mn_shell_display_about_dialog
#define self_display_window mn_shell_display_window
#define self_close_mail_summary_popup mn_shell_close_mail_summary_popup
#define self_add_mailbox_properties_dialog mn_shell_add_mailbox_properties_dialog
#define self_mailbox_properties_dialog_weak_notify_cb mn_shell_mailbox_properties_dialog_weak_notify_cb
#define self_get_mailbox_properties_dialog mn_shell_get_mailbox_properties_dialog
GType
mn_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNShell *)g_object_new(mn_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNShell *
GET_NEW_VARG (const char *first, ...)
{
	MNShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNShell *)g_object_new_valist (mn_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::dispose"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	if (G_OBJECT_CLASS (parent_class)->dispose) \
		(* G_OBJECT_CLASS (parent_class)->dispose) (obj_self);
#line 58 "mn-shell.gob"
	if(self->mailboxes) { g_object_unref ((gpointer) self->mailboxes); self->mailboxes = NULL; }
#line 195 "mn-shell.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
	MNShell *self G_GNUC_UNUSED = MN_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 100 "mn-shell.gob"
	___2_mn_shell_finalize(obj_self);
#line 208 "mn-shell.c"
#line 67 "mn-shell.gob"
	if(self->_priv->popup_messages) { mn_g_object_slist_free ((gpointer) self->_priv->popup_messages); self->_priv->popup_messages = NULL; }
#line 211 "mn-shell.c"
#line 68 "mn-shell.gob"
	if(self->_priv->popup_previous_messages) { g_hash_table_destroy ((gpointer) self->_priv->popup_previous_messages); self->_priv->popup_previous_messages = NULL; }
#line 214 "mn-shell.c"
}
#undef __GOB_FUNCTION__

static void 
mn_shell_class_init (MNShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 100 "mn-shell.gob"
	g_object_class->finalize = ___finalize;
#line 230 "mn-shell.c"
	g_object_class->dispose = ___dispose;
}
#undef __GOB_FUNCTION__
#line 72 "mn-shell.gob"
static void 
mn_shell_init (MNShell * self G_GNUC_UNUSED)
#line 237 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_SHELL,MNShellPrivate);
#line 58 "mn-shell.gob"
	self->mailboxes = mn_mailboxes_new();
#line 243 "mn-shell.c"
#line 68 "mn-shell.gob"
	self->_priv->popup_previous_messages = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_object_unref);
#line 246 "mn-shell.c"
 {
#line 73 "mn-shell.gob"

    g_assert(mn_shell == NULL);

    mn_shell = self;
    eel_add_weak_pointer(&mn_shell);

    self_init_icon(self);

    mn_g_object_gconf_notifications_add_gdk_locked(self,
						   MN_CONF_BLINK_ON_ERRORS, self_notify_blink_on_errors_cb, self,
						   MN_CONF_ALWAYS_DISPLAY_ICON, self_notify_always_display_icon_cb, self,
						   MN_CONF_GNOME_MAIL_READER_NAMESPACE, self_notify_mail_reader_cb, self,
						   MN_CONF_TOOLTIP_MAIL_SUMMARY, self_notify_tooltip_mail_summary_cb, self,
						   MN_CONF_MAIL_SUMMARY_POPUP_ENABLE, self_notify_mail_summary_popup_enable_cb, self,
						   NULL);

    g_object_connect(self->mailboxes,
		     "signal::messages-changed", self_messages_changed_h, self,
		     "signal::mailbox-removed", self_mailbox_removed_h, self,
		     "swapped-signal::notify::poll", self_update_sensitivity, self,
		     "swapped-signal::list-changed", self_update_tooltip, self,
		     "swapped-signal::list-changed", self_update_icon, self,
		     "swapped-signal::error-changed", self_update_tooltip, self,
		     "swapped-signal::error-changed", self_update_icon, self,
		     NULL);
  
#line 275 "mn-shell.c"
 }
}
#undef __GOB_FUNCTION__



#line 100 "mn-shell.gob"
static void 
___2_mn_shell_finalize (GObject * object G_GNUC_UNUSED)
#line 285 "mn-shell.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Shell::finalize"
{
#line 102 "mn-shell.gob"
	
    gtk_main_quit();
    PARENT_HANDLER(object);
  }}
#line 297 "mn-shell.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 107 "mn-shell.gob"
static void 
mn_shell_messages_changed_h (MNMailboxes * mailboxes, gboolean has_new, gpointer user_data)
#line 304 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::messages_changed_h"
{
#line 111 "mn-shell.gob"
	
    Self *self = user_data;

    if (has_new)
      {
	if (mn_conf_has_command(MN_CONF_COMMANDS_NEW_MAIL_NAMESPACE))
	  mn_conf_execute_command(MN_CONF_COMMANDS_NEW_MAIL_COMMAND, FALSE);
      }

    if (eel_gconf_get_boolean(MN_CONF_MAIL_SUMMARY_POPUP_ENABLE))
      self_update_popup(self, has_new);

    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 324 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 127 "mn-shell.gob"
static void 
mn_shell_mailbox_removed_h (MNMailboxes * mailboxes, MNMailbox * mailbox, gpointer user_data)
#line 330 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_removed_h"
{
#line 131 "mn-shell.gob"
	
    Self *self = user_data;
    MNMailboxPropertiesDialog *dialog;

    /* destroy the associated properties dialog, if any */
    dialog = self_get_mailbox_properties_dialog(self, mailbox);
    if (dialog)
      gtk_widget_destroy(GTK_WIDGET(dialog));
  }}
#line 344 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 141 "mn-shell.gob"
static void 
mn_shell_init_icon (MNShell * self)
#line 350 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::init_icon"
#line 141 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 141 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 357 "mn-shell.c"
{
#line 143 "mn-shell.gob"
	
    selfp->icon = MN_MAIL_ICON(mn_mail_icon_new());

    g_object_connect(selfp->icon,
		     "signal::activate", self_icon_activate_h, self,
		     "signal::activate-mail-reader", self_icon_activate_mail_reader_h, self,
		     "signal::activate-update", self_icon_activate_update_h, self,
		     "signal::activate-properties", self_icon_activate_properties_h, self,
		     "signal::activate-help", self_icon_activate_help_h, self,
		     "signal::activate-about", self_icon_activate_about_h, self,
		     "signal::activate-remove", self_icon_activate_remove_h, self,
		     "signal::destroy", self_icon_destroy_h, self,
		     NULL);

    self_update_sensitivity(self);
    self_update_tooltip(self);
    self_update_icon(self);
  }}
#line 378 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 162 "mn-shell.gob"
static void 
mn_shell_notify_blink_on_errors_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 384 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_blink_on_errors_cb"
{
#line 167 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_icon(self);
  }}
#line 394 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 173 "mn-shell.gob"
static void 
mn_shell_notify_always_display_icon_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 400 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_always_display_icon_cb"
{
#line 178 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_icon(self);
  }}
#line 410 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 184 "mn-shell.gob"
static void 
mn_shell_notify_mail_reader_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 416 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_reader_cb"
{
#line 189 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_sensitivity(self);
  }}
#line 426 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 195 "mn-shell.gob"
static void 
mn_shell_notify_tooltip_mail_summary_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 432 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_tooltip_mail_summary_cb"
{
#line 200 "mn-shell.gob"
	
    Self *self = user_data;

    self_update_tooltip(self);
  }}
#line 442 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 206 "mn-shell.gob"
static void 
mn_shell_notify_mail_summary_popup_enable_cb (GConfClient * client, unsigned int cnxn_id, GConfEntry * entry, gpointer user_data)
#line 448 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::notify_mail_summary_popup_enable_cb"
{
#line 211 "mn-shell.gob"
	
    Self *self = user_data;

    if (selfp->popup && ! eel_gconf_get_boolean(MN_CONF_MAIL_SUMMARY_POPUP_ENABLE))
      gtk_widget_destroy(selfp->popup);
  }}
#line 459 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 218 "mn-shell.gob"
static void 
mn_shell_icon_activate_h (MNMailIcon * icon, gpointer user_data)
#line 465 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_h"
{
#line 220 "mn-shell.gob"
	
    MNShell *self = user_data;
    MNAction action;

    action = mn_conf_get_enum_value(MN_TYPE_ACTION, MN_CONF_CLICK_ACTION);

    switch (action)
      {
      case MN_ACTION_DISPLAY_PROPERTIES_DIALOG:
	self_display_properties_dialog(self);
	break;

      case MN_ACTION_LAUNCH_MAIL_READER:
	if (mn_conf_has_command(MN_CONF_GNOME_MAIL_READER_NAMESPACE))
	  mn_conf_execute_command(MN_CONF_GNOME_MAIL_READER_COMMAND, TRUE);
	break;

      case MN_ACTION_UPDATE_MAIL_STATUS:
	mn_mailboxes_check(self->mailboxes);
	break;

      default:
	g_assert_not_reached();
      }
  }}
#line 495 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 246 "mn-shell.gob"
static void 
mn_shell_icon_activate_mail_reader_h (MNMailIcon * icon, gpointer user_data)
#line 501 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_mail_reader_h"
{
#line 248 "mn-shell.gob"
	
    mn_conf_execute_command(MN_CONF_GNOME_MAIL_READER_COMMAND, TRUE);
  }}
#line 509 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 252 "mn-shell.gob"
static void 
mn_shell_icon_activate_update_h (MNMailIcon * icon, gpointer user_data)
#line 515 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_update_h"
{
#line 254 "mn-shell.gob"
	
    Self *self = user_data;
    mn_mailboxes_check(self->mailboxes);
  }}
#line 524 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 259 "mn-shell.gob"
static void 
mn_shell_icon_activate_properties_h (MNMailIcon * icon, gpointer user_data)
#line 530 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_properties_h"
{
#line 261 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_properties_dialog(self);
  }}
#line 539 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 266 "mn-shell.gob"
static void 
mn_shell_icon_activate_help_h (MNMailIcon * icon, gpointer user_data)
#line 545 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_help_h"
{
#line 268 "mn-shell.gob"
	
    mn_display_help(NULL, NULL);
  }}
#line 553 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 272 "mn-shell.gob"
static void 
mn_shell_icon_activate_about_h (MNMailIcon * icon, gpointer user_data)
#line 559 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_about_h"
{
#line 274 "mn-shell.gob"
	
    Self *self = user_data;
    self_display_about_dialog(self);
  }}
#line 568 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 279 "mn-shell.gob"
static void 
mn_shell_icon_activate_remove_h (MNMailIcon * icon, gpointer user_data)
#line 574 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_activate_remove_h"
{
#line 281 "mn-shell.gob"
	
    Self *self = user_data;
    g_object_unref(self);
  }}
#line 583 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 286 "mn-shell.gob"
static void 
mn_shell_icon_destroy_h (GtkObject * object, gpointer user_data)
#line 589 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::icon_destroy_h"
{
#line 288 "mn-shell.gob"
	
    Self *self = user_data;

    /* The Notification Area applet has been terminated. Recreate the icon. */
    self_init_icon(self);
  }}
#line 600 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 295 "mn-shell.gob"
static void 
mn_shell_update_sensitivity (MNShell * self)
#line 606 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_sensitivity"
#line 295 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 295 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 613 "mn-shell.c"
{
#line 297 "mn-shell.gob"
	
    gtk_widget_set_sensitive(selfp->icon->mail_reader_item, mn_conf_has_command(MN_CONF_GNOME_MAIL_READER_NAMESPACE));
    gtk_widget_set_sensitive(selfp->icon->update_item, mn_mailboxes_get_poll(self->mailboxes));
  }}
#line 620 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 302 "mn-shell.gob"
static void 
mn_shell_update_icon (MNShell * self)
#line 626 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_icon"
#line 302 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 302 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 633 "mn-shell.c"
{
#line 304 "mn-shell.gob"
	
    GList *l;
    gboolean has_new = FALSE;
    gboolean blink = FALSE;
    gboolean always = eel_gconf_get_boolean(MN_CONF_ALWAYS_DISPLAY_ICON);

    MN_LIST_FOREACH(l, self->mailboxes->list)
      {
	MNMailbox *mailbox = l->data;

	if (mailbox->messages)
	  has_new = TRUE;
	if (mailbox->error)
	  blink = TRUE;
      }

    if (selfp->has_new && ! has_new && mn_conf_has_command(MN_CONF_COMMANDS_MAIL_READ_NAMESPACE))
      mn_conf_execute_command(MN_CONF_COMMANDS_MAIL_READ_COMMAND, FALSE);
    selfp->has_new = has_new;

    if (blink && ! eel_gconf_get_boolean(MN_CONF_BLINK_ON_ERRORS))
      blink = FALSE;

    if (has_new || blink || always)
      {
	mn_blinking_image_set_from_stock(MN_BLINKING_IMAGE(selfp->icon->image),
					 has_new ? MN_STOCK_MAIL : MN_STOCK_NO_MAIL,
					 GTK_ICON_SIZE_LARGE_TOOLBAR);
	mn_blinking_image_set_blinking(MN_BLINKING_IMAGE(selfp->icon->image),
				       blink);
	gtk_widget_show(GTK_WIDGET(selfp->icon));
      }
    else
      gtk_widget_hide(GTK_WIDGET(selfp->icon));
  }}
#line 671 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 340 "mn-shell.gob"
static void 
mn_shell_update_tooltip (MNShell * self)
#line 677 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_tooltip"
#line 340 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 340 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 684 "mn-shell.c"
{
#line 342 "mn-shell.gob"
	
    GtkVBox *vbox = NULL;

    if (self->mailboxes->list)
      {
	GList *la;
	GSList *lb;
	GSList *new_mailboxes = NULL;
	GSList *error_mailboxes = NULL;

	MN_LIST_FOREACH(la, self->mailboxes->list)
          {
	    MNMailbox *mailbox = la->data;

	    if (mailbox->messages)
	      new_mailboxes = g_slist_insert_sorted(new_mailboxes, mailbox, (GCompareFunc) self_new_mailboxes_compare_cb);

	    if (mailbox->error)
	      error_mailboxes = g_slist_insert_sorted(error_mailboxes, mailbox, mn_mailboxes_compare_by_name_func);
	  }

	if (new_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    MN_LIST_FOREACH(lb, new_mailboxes)
	      {
		MNMailbox *mailbox = lb->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append(string, mailbox->runtime_name);

		if (mailbox->n_messages > 0)
		  g_string_append_printf(string, " (%i)", mailbox->n_messages);
	      }
	    g_slist_free(new_mailboxes);

	    /* translators: header capitalization */
	    self_tooltip_text_section_new(&vbox, _("Mailboxes Having New Mail"), string->str);
	    g_string_free(string, TRUE);
	  }

	if (error_mailboxes)
	  {
	    GString *string = g_string_new(NULL);

	    MN_LIST_FOREACH(lb, error_mailboxes)
	      {
		MNMailbox *mailbox = lb->data;

		if (*string->str)
		  g_string_append_c(string, '\n');
		g_string_append_printf(string, "%s: %s", mailbox->runtime_name, mailbox->error);
	      }
	    g_slist_free(error_mailboxes);

	    /* translators: header capitalization */
	    self_tooltip_text_section_new(&vbox, _("Errors"), string->str);
	    g_string_free(string, TRUE);
	  }
      }

    if (self->mailboxes->messages)
      {
	MNShellTooltipMailSummary mail_summary;

	mail_summary = mn_conf_get_enum_value(MN_TYPE_SHELL_TOOLTIP_MAIL_SUMMARY, MN_CONF_TOOLTIP_MAIL_SUMMARY);
	if (mail_summary != MN_SHELL_TOOLTIP_MAIL_SUMMARY_NONE)
	  {
	    GtkWidget *alignment;
	    GtkWidget *message_view;

	    /* translators: header capitalization */
	    alignment = self_tooltip_section_new(&vbox, _("Mail Summary"));

	    switch (mail_summary)
	      {
	      case MN_SHELL_TOOLTIP_MAIL_SUMMARY_STANDARD:
		message_view = mn_standard_message_view_new();
		break;

	      case MN_SHELL_TOOLTIP_MAIL_SUMMARY_COMPACT:
		message_view = mn_compact_message_view_new();
		break;

	      default:
		g_assert_not_reached();
		break;
	      }

	    gtk_widget_set_name(message_view, "mn-message-view");
	    mn_message_view_set_messages(MN_MESSAGE_VIEW(message_view), self->mailboxes->messages);
	    gtk_container_add(GTK_CONTAINER(alignment), message_view);
	  }
      }

    if (vbox)
      {
	gtk_widget_show_all(GTK_WIDGET(vbox));
	mn_mail_icon_set_tip_widget(selfp->icon, GTK_WIDGET(vbox));
      }
    else
      mn_mail_icon_set_tip(selfp->icon, _("You have no new mail."));
  }}
#line 792 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 448 "mn-shell.gob"
static int 
mn_shell_new_mailboxes_compare_cb (MNMailbox * a, MNMailbox * b)
#line 798 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new_mailboxes_compare_cb"
{
#line 450 "mn-shell.gob"
	
    int cmp;

    /* sort by timestamp (descending order) */
    cmp = b->timestamp - a->timestamp;
    /* else sort by number of messages (descending order) */
    if (cmp == 0)
      {
	cmp = b->n_messages - a->n_messages;
	/* else sort by name (ascending order) */
	if (cmp == 0)
	  cmp = mn_mailboxes_compare_by_name_func(a, b);
      }

    return cmp;
  }}
#line 819 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 467 "mn-shell.gob"
static GtkWidget * 
mn_shell_tooltip_section_new (GtkVBox ** vbox, const char * title)
#line 825 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_section_new"
#line 467 "mn-shell.gob"
	g_return_val_if_fail (vbox != NULL, (GtkWidget * )0);
#line 467 "mn-shell.gob"
	g_return_val_if_fail (title != NULL, (GtkWidget * )0);
#line 832 "mn-shell.c"
{
#line 470 "mn-shell.gob"
	
    GtkWidget *child_vbox;
    char *markup;
    GtkWidget *alignment;
    GtkWidget *label;

    if (! *vbox)
      *vbox = GTK_VBOX(gtk_vbox_new(FALSE, 18));

    child_vbox = gtk_vbox_new(FALSE, 6);

    markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>", title);
    label = gtk_label_new(markup);
    g_free(markup);

    gtk_widget_set_name(label, "mn-tooltip-section-title");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_label_set_use_markup(GTK_LABEL(label), TRUE);

    gtk_box_pack_start(GTK_BOX(child_vbox), label, FALSE, FALSE, 0);

    alignment = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
    gtk_alignment_set_padding(GTK_ALIGNMENT(alignment), 0, 0, 12, 0);

    gtk_box_pack_start(GTK_BOX(child_vbox), alignment, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(*vbox), child_vbox, TRUE, TRUE, 0);

    return alignment;
  }}
#line 864 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 500 "mn-shell.gob"
static void 
mn_shell_tooltip_text_section_new (GtkVBox ** vbox, const char * title, const char * text)
#line 870 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::tooltip_text_section_new"
#line 500 "mn-shell.gob"
	g_return_if_fail (vbox != NULL);
#line 500 "mn-shell.gob"
	g_return_if_fail (title != NULL);
#line 500 "mn-shell.gob"
	g_return_if_fail (text != NULL);
#line 879 "mn-shell.c"
{
#line 504 "mn-shell.gob"
	
    GtkWidget *alignment;
    GtkWidget *label;

    alignment = self_tooltip_section_new(vbox, title);

    label = gtk_label_new(text);
    gtk_widget_set_name(label, "mn-tooltip-section-body");
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

    gtk_container_add(GTK_CONTAINER(alignment), label);
  }}
#line 894 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 517 "mn-shell.gob"
static void 
mn_shell_update_popup (MNShell * self, gboolean has_new)
#line 900 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::update_popup"
#line 517 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 517 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 907 "mn-shell.c"
{
#line 519 "mn-shell.gob"
	
    if ((! selfp->properties_dialog || ! mn_properties_dialog_test_popup_displayed(MN_PROPERTIES_DIALOG(selfp->properties_dialog)))
	&& (selfp->popup || has_new))
      {
	GSList *l;
	GHashTable *messages;

	mn_g_object_slist_free(selfp->popup_messages);
	selfp->popup_messages = mn_g_object_slist_copy(self->mailboxes->messages);

	/* 1. clean popup_previous_messages */

	messages = g_hash_table_new(g_str_hash, g_str_equal);
	MN_LIST_FOREACH(l, selfp->popup_messages)
	  {
	    MNMessage *message = l->data;
	    g_hash_table_replace(messages, message->id, message);
	  }

	g_hash_table_foreach_remove(selfp->popup_previous_messages, (GHRFunc) self_clean_popup_previous_messages_cb, messages);
	g_hash_table_destroy(messages);

	/* 2. hide messages which are listed in popup_previous_messages */

	if (eel_gconf_get_boolean(MN_CONF_MAIL_SUMMARY_POPUP_ONLY_RECENT))
	  for (l = selfp->popup_messages; l != NULL;)
	    {
	      MNMessage *message = l->data;
	      GSList *next = l->next;

	      if (g_hash_table_lookup(selfp->popup_previous_messages, message->id))
		selfp->popup_messages = mn_g_object_slist_delete_link(selfp->popup_messages, l);

	      l = next;
	    }

	/* 3. display the resulting list in the popup */

	if (selfp->popup_messages)
	  {
	    if (! selfp->popup)
	      {
		selfp->popup = mn_mail_summary_popup_new();

		eel_add_weak_pointer(&selfp->popup);
		g_object_weak_ref(G_OBJECT(selfp->popup), (GWeakNotify) self_popup_weak_notify_cb, self);
	      }

	    mn_mail_summary_popup_set_messages(MN_MAIL_SUMMARY_POPUP(selfp->popup), selfp->popup_messages);
	    gtk_widget_show(selfp->popup);

	    /* we only reset the timeout if there is new mail */

	    if (has_new)
	      mn_mail_summary_popup_reset_timeout(MN_MAIL_SUMMARY_POPUP(selfp->popup));

	    return;		/* something has been shown */
	  }
      }

    /* nothing has been shown, destroy the popup if it exists */
    if (selfp->popup)
      gtk_widget_destroy(selfp->popup);
  }}
#line 974 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 584 "mn-shell.gob"
static gboolean 
mn_shell_clean_popup_previous_messages_cb (const char * id, MNMessage * message, gpointer user_data)
#line 980 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::clean_popup_previous_messages_cb"
{
#line 588 "mn-shell.gob"
	
    GHashTable *messages = user_data;
    return g_hash_table_lookup(messages, id) == NULL;
  }}
#line 989 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 593 "mn-shell.gob"
static void 
mn_shell_popup_weak_notify_cb (MNShell * self, GObject * former_object)
#line 995 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::popup_weak_notify_cb"
#line 593 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 593 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1002 "mn-shell.c"
{
#line 595 "mn-shell.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->popup_messages)
      {
	MNMessage *message = l->data;
	g_hash_table_replace(selfp->popup_previous_messages, message->id, message);
      }

    /*
     * We do not use mn_g_object_slist_clear() because we have passed
     * the messages ownership to the hash table.
     */
    mn_g_slist_clear(&selfp->popup_messages);
  }}
#line 1020 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 611 "mn-shell.gob"
MNShell * 
mn_shell_new (void)
#line 1026 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::new"
{
#line 613 "mn-shell.gob"
	
    return GET_NEW;
  }}
#line 1034 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 617 "mn-shell.gob"
void 
mn_shell_display_properties_dialog (MNShell * self)
#line 1040 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_properties_dialog"
#line 617 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 617 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1047 "mn-shell.c"
{
#line 619 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_PROPERTIES_DIALOG, &selfp->properties_dialog);
  }}
#line 1053 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 623 "mn-shell.gob"
void 
mn_shell_display_about_dialog (MNShell * self)
#line 1059 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_about_dialog"
#line 623 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 623 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1066 "mn-shell.c"
{
#line 625 "mn-shell.gob"
	
    self_display_window(self, MN_TYPE_ABOUT_DIALOG, &selfp->about_dialog);
  }}
#line 1072 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 629 "mn-shell.gob"
static void 
mn_shell_display_window (MNShell * self, GType type, GtkWidget ** ptr)
#line 1078 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::display_window"
#line 629 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 629 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 629 "mn-shell.gob"
	g_return_if_fail (type != 0);
#line 629 "mn-shell.gob"
	g_return_if_fail (ptr != NULL);
#line 1089 "mn-shell.c"
{
#line 633 "mn-shell.gob"
	
    if (*ptr)
      {
	gtk_window_present(GTK_WINDOW(*ptr));
	return;
      }

    *ptr = g_object_new(type, NULL);
    eel_add_weak_pointer(ptr);

    gtk_widget_show(*ptr);
  }}
#line 1104 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 646 "mn-shell.gob"
void 
mn_shell_close_mail_summary_popup (MNShell * self)
#line 1110 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::close_mail_summary_popup"
#line 646 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 646 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 1117 "mn-shell.c"
{
#line 648 "mn-shell.gob"
	
    if (selfp->popup)
      gtk_widget_destroy(selfp->popup);
  }}
#line 1124 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 653 "mn-shell.gob"
void 
mn_shell_add_mailbox_properties_dialog (MNShell * self, MNMailboxPropertiesDialog * dialog)
#line 1130 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::add_mailbox_properties_dialog"
#line 653 "mn-shell.gob"
	g_return_if_fail (self != NULL);
#line 653 "mn-shell.gob"
	g_return_if_fail (MN_IS_SHELL (self));
#line 653 "mn-shell.gob"
	g_return_if_fail (dialog != NULL);
#line 653 "mn-shell.gob"
	g_return_if_fail (MN_IS_MAILBOX_PROPERTIES_DIALOG (dialog));
#line 1141 "mn-shell.c"
{
#line 655 "mn-shell.gob"
	
    selfp->mailbox_properties_dialogs = g_slist_append(selfp->mailbox_properties_dialogs, dialog);
    g_object_weak_ref(G_OBJECT(dialog), self_mailbox_properties_dialog_weak_notify_cb, self);
  }}
#line 1148 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 660 "mn-shell.gob"
static void 
mn_shell_mailbox_properties_dialog_weak_notify_cb (gpointer data, GObject * former_object)
#line 1154 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::mailbox_properties_dialog_weak_notify_cb"
{
#line 663 "mn-shell.gob"
	
    Self *self = data;

    selfp->mailbox_properties_dialogs = g_slist_remove(selfp->mailbox_properties_dialogs, former_object);
  }}
#line 1164 "mn-shell.c"
#undef __GOB_FUNCTION__

#line 669 "mn-shell.gob"
MNMailboxPropertiesDialog * 
mn_shell_get_mailbox_properties_dialog (MNShell * self, MNMailbox * mailbox)
#line 1170 "mn-shell.c"
{
#define __GOB_FUNCTION__ "MN:Shell::get_mailbox_properties_dialog"
#line 669 "mn-shell.gob"
	g_return_val_if_fail (self != NULL, (MNMailboxPropertiesDialog * )0);
#line 669 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_SHELL (self), (MNMailboxPropertiesDialog * )0);
#line 669 "mn-shell.gob"
	g_return_val_if_fail (mailbox != NULL, (MNMailboxPropertiesDialog * )0);
#line 669 "mn-shell.gob"
	g_return_val_if_fail (MN_IS_MAILBOX (mailbox), (MNMailboxPropertiesDialog * )0);
#line 1181 "mn-shell.c"
{
#line 671 "mn-shell.gob"
	
    GSList *l;

    MN_LIST_FOREACH(l, selfp->mailbox_properties_dialogs)
      {
	MNMailboxPropertiesDialog *dialog = l->data;
	MNMailbox *this_mailbox;
	gboolean found;

	this_mailbox = mn_mailbox_properties_dialog_get_mailbox(dialog);
	found = this_mailbox == mailbox;
	g_object_unref(this_mailbox);

	if (found)
	  return dialog;
      }

    return NULL;
  }}
#line 1203 "mn-shell.c"
#undef __GOB_FUNCTION__
static const GEnumValue _mn_position_values[] = {
	{ MN_POSITION_TOP_LEFT, (char *)"MN_POSITION_TOP_LEFT", (char *)"top-left" },
	{ MN_POSITION_TOP_RIGHT, (char *)"MN_POSITION_TOP_RIGHT", (char *)"top-right" },
	{ MN_POSITION_BOTTOM_LEFT, (char *)"MN_POSITION_BOTTOM_LEFT", (char *)"bottom-left" },
	{ MN_POSITION_BOTTOM_RIGHT, (char *)"MN_POSITION_BOTTOM_RIGHT", (char *)"bottom-right" },
	{ 0, NULL, NULL }
};

GType
mn_position_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNPosition", _mn_position_values);
	return type;
}

static const GEnumValue _mn_action_values[] = {
	{ MN_ACTION_DISPLAY_PROPERTIES_DIALOG, (char *)"MN_ACTION_DISPLAY_PROPERTIES_DIALOG", (char *)"display-properties-dialog" },
	{ MN_ACTION_LAUNCH_MAIL_READER, (char *)"MN_ACTION_LAUNCH_MAIL_READER", (char *)"launch-mail-reader" },
	{ MN_ACTION_UPDATE_MAIL_STATUS, (char *)"MN_ACTION_UPDATE_MAIL_STATUS", (char *)"update-mail-status" },
	{ 0, NULL, NULL }
};

GType
mn_action_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAction", _mn_action_values);
	return type;
}

static const GEnumValue _mn_aspect_source_values[] = {
	{ MN_ASPECT_SOURCE_THEME, (char *)"MN_ASPECT_SOURCE_THEME", (char *)"theme" },
	{ MN_ASPECT_SOURCE_CUSTOM, (char *)"MN_ASPECT_SOURCE_CUSTOM", (char *)"custom" },
	{ 0, NULL, NULL }
};

GType
mn_aspect_source_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("MNAspectSource", _mn_aspect_source_values);
	return type;
}

