/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public abstract class AbstractBrowserLauncher
implements BrowserLauncher {
    protected String sessionId;
    private RemoteControlConfiguration configuration;
    protected BrowserConfigurationOptions browserConfigurationOptions;

    public AbstractBrowserLauncher(String sessionId, RemoteControlConfiguration configuration, BrowserConfigurationOptions browserOptions) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.browserConfigurationOptions = browserOptions;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, !this.browserConfigurationOptions.isSingleWindow(), 0));
    }

    public void launchRemoteSession(String browserURL) {
        boolean browserSideLog = this.browserConfigurationOptions.is("browserSideLog");
        if (browserSideLog) {
            this.configuration.getSeleniumServer().generateSSLCertsForLoggingHosts();
        }
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, !this.browserConfigurationOptions.isSingleWindow(), 0, browserSideLog));
    }

    protected abstract void launch(String var1);

    public RemoteControlConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getPort() {
        return this.configuration.getPortDriversShouldContact();
    }
}

