from mago.test_suite.evolution import EvolutionTestSuite
from mago.application.evolution import Evolution, AccountInfo
from mago.check import ScreenshotCompare, FAIL
from mago.application.deskex import IndicatorApplet 

from ConfigParser import ConfigParser
import ldtp, ooldtp, ldtputils
from time import sleep, time
from shutil import copytree, move
from os.path import expanduser

class EvolutionUseApp(Evolution):
    def open(self, profile_template='', credentials='',
             me_account=''):
        self.me_account = AccountInfo(me_account, credentials)

        self.backup_config()
        self.generate_profile(profile_template, self.me_account.template_args)

        Evolution.open(self, False, credentials)

class EvolutionIndicatorTest(EvolutionTestSuite):
    APPLICATION_FACTORY = EvolutionUseApp
    def cleanup(self):
        return

    def testIndicatorShowsUp(self):
        indicator = IndicatorApplet()
        if not indicator.is_server_shown("Evolution Mail"):
            raise AssertionError("The indicator didn't show up", ldtputils.imagecapture())





  
