#!/usr/bin/perl

use XML::Parser;
use Time::localtime;

my $file = shift;
my $dir = shift;
my $Author="MagicsTeam";
my $ecmwf="http://wms.ecmwf.int";
my $info = {};
my $element = {};

my %direct = {
    "int" => "ParameterManager::getInt",
    "float" => "ParameterManager::getDouble",
    "string" => "ParameterManager::getString",
};

my %basetype = (
    "int" => 1,
    "float" => 1,
    "string" => 1,
    "bool"=>1,
    "floatarray" =>1,
    "stringarray" => 1,
    "intarray" => 1, 
    "LineStyle" =>1,
    "ListPolicy" =>1,
    "Hemisphere" =>1,
    "ArrowPosition" => 1,
    "Justification" => 1,
    "DisplayType" => 1,
    "OpenGLDriverObserverPtr" => 1,
    "Widget" =>1, 
    "cairo_t" =>1, 
    "Matrix" => 1,
    "GribHandlePtr" =>1,  
);

my %magtype = (
	"float" =>'double',
);

my %classtype = (
	"Colour" =>1,
);

my %arraytype = (
	"floatarray" => "atof(data)",
	"stringarray" => "data",
	"intarray" => "atoi(data)",
);

my %quote = (
    "string" => 1,
);

sub parse
{
    my $def = shift;
    my $node = shift;   
   
    while ( defined ( $element = shift @{ $node } ) )
    {
       
        my $child = shift @{ $node };
        if ( ref $child )
        {
           my $attr = \%{ shift @{ $child } };
           my $name = $attr->{name};
           
           if ($name ne "") 
           {
               
               $def->{$element}->{$name} = {};
               my $list = $element . "_list";
               push( @{$def->{$list}}, $name);
               foreach my $a (keys %{$attr}) 
               {
                   $def->{$element}->{$name}->{attributes}->{$a} = $attr->{$a}; 
                  
               }
               parse($def->{$element}->{$name}, $child); 
               
           }
           else
           {
                   $def->{$element} = {};
                   foreach my $a (keys %{$attr}) 
                   {
                        $def->{$element}->{attributes}->{$a} = $attr->{$a};
                       
                   }
                   parse($def->{$element}, $child); 
           }
        }
        else 
        {
         
          $def->{data} = $child;
        }
    }   
}





my $xml= new XML::Parser(Style=>"Tree");
  
parse ($info, $xml->parsefile($file));

foreach my $object (keys %{$info->{magics}->{class}}) 
{
   
    $current = $info->{magics}->{class}->{$object};
    $directory = $info->{magics}->{class}->{$object}->{attributes}->{directory};
    

######################################################
#####                Include file

    open STDOUT, ">$dir/$directory/$object\Attributes.h";

    my $string =  ctime();
    print  <<EOF;

/*! \\file $object\Attributes.h
    \\brief Definition of $object Attributes class.
    This file is automatically generated.
    Do Not Edit!
    
    Magics Team - ECMWF 2004
   
    Created: $string
    
*/
   

#ifndef $object\Attributes_H
#define $object\Attributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


EOF
    my $includes = {};
    my @impl=split(/\//, $current->{attributes}->{implements});
    my @interfaces = (split(/\//, $current->{attributes}->{interface}), @impl);
    foreach $i (@impl) 
    {
        
        print "#include \"$i.h\"\n";
    }
    
    my $parent ='';
    my $sep = ":";
    foreach $interface (@interfaces) 
    {
        
        $parent="$parent$sep public $interface";
        $sep = ", " 
    }
    
    
    foreach my $param (@{$current->{parameter_list}}) 
    {   
       my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
       next if $todo eq 'no';
       my $to = $current->{parameter}->{$param}->{attributes}->{to};
       my $include = $current->{parameter}->{$param}->{attributes}->{include};
       
       if ( !$basetype{$to} )
       {
            if   ($include eq "" ) {
                $includes->{"$to.h"} = "ok";
            }
            else 
            {
                $includes->{$include} = "ok";
            }    
        }
     
    }
    foreach my $include (keys %{$includes} ) 
    {
          print "#include \"$include\"\n"; 
    }
    
    print "\n";
  
    
    my $template = $current->{attributes}->{template_attributes};
    my $class = "$object\Attributes";
    my $line = "";
    if ( $template ne "" ) {
        $line = "template <class $template>";
        $class = "$object\Attributes<$template>";
        
    }
    
    print <<EOF;
namespace magics {

class XmlNode;


$line
class $object\Attributes $parent
{
public:
//  --  constructor
    $object\Attributes();
    
//  --  destructor
    virtual ~$object\Attributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const $object\Attributes&);
    
    void setTag(const string& tag) { tag_ = tag; }
   
    
EOF
    my $xml_data = $current->{attributes}->{xml_data};
    if ($xml_data eq '' ) {
        print <<EOF;
    void setXmlData(const string&)  {}
EOF
    }
    else {
    	my $to = $current->{parameter}->{$xml_data}->{attributes}->{to};
    	my $member = $current->{parameter}->{$xml_data}->{attributes}->{member};
    	if ( $arraytype{$to} ) {    		
    		print("\tvoid setXmlData(const string& data)  { $member\_.push_back($arraytype{$to}); } \n");
    	}
    	else {
    		print("\tvoid setXmlData(const string& data)  { $member\_ = data; }\n");
    	}
    }
    
   
    
    foreach  my $param (@{$current->{parameter_list}}) 
    {      
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        $to = "$to<$tpl> " unless $tpl eq "";
       
        my $value = lc $member;
        my $method = ucfirst $member;
        
        print <<EOF;
/*!
 *   Magics Information:
 *     - Parameter name: $name 
 *     - Default: $default
 */
EOF
    my $magto = $to;
    $magto = $magtype{$magto} if $magtype{$magto};
    

    if ( $basetype{$to} ) 
    { 
        print <<EOF;   
	void set$method($magto $value) 
		{ $member\_ =  $value; } 
	$magto get$method() const 
		{ return $member\_; } 
        
EOF
    }
    else
    {
        print <<EOF;   
	void set$method($to* $value) 
		{ auto_ptr<$to> tmp($value); $member\_ = tmp; } 
	const $to&  get$method() const 
		{ return *$member\_; }
     
EOF
    }
    
    }

    print <<EOF;
    virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }
    
protected:
//  --  method
	virtual void print(ostream&) const;
	
	virtual void toxml(ostream&, const string&, int tabs) const;

//  --  members:
	string tag_;
EOF
     
     print "\tstring $xml_data\_;\n" unless $xml_data eq ''; 
     foreach  my $param (@{$current->{parameter_list}}) 
    {      
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        $to = "$to<$tpl> " unless $tpl eq "";
        
        if ( $magtype{$to}  )
        { 
            print "\t$magtype{$to} $member\_;\n";
        }
        elsif ( $basetype{$to} ) 
        { 
            print "\t$to $member\_;\n";
        }
        else 
        {
            print "\tauto_ptr<$to> $member\_;\n";  
        }
    }

print <<EOF;   

private:
  
	friend ostream& operator<<(ostream& s,const $class& p)
	{ p.print(s); return s; }
};

} // namespace magics
EOF

    if ( $template ne "" ) {
        print "#include \"$object\Attributes.cc\" \n";
    }
    
    print "\n#endif\n";
 
    close STDOUT;
    
#####                Include file
######################################################

######################################################
#####                Source file

    open STDOUT, ">$dir/$directory/$object\Attributes.cc";
    
 
    print  <<EOF;
/*! \\file $object\Attributes.cc
    \\brief Implemtation of $object Attributes class.
    This file is automatically generated.
    Do Not Edit!
    
    Magics Team - ECMWF 2004
   
    Created: $string
    
*/    

    
#include "$object\Attributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"

using namespace magics;

EOF
   $header = "";
    $p = "";
   if ( $template ne "" ) {
        $header = "template <class $template>";
        $p = "<P>";
    }
    
    my $count = 0;
    
    foreach  my $param (@{$current->{parameter_list}}) 
    {      
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        next if $todo eq 'no';
        next if $tpl  ne "";
        $count++;
    }
    
    my $subclass = ":";
    $subclass = "" if $count eq 0; 
    
    print "$header\n$object\Attributes$p\::$object\Attributes()$subclass"; 
    my $sep = ""; 
    foreach  my $param (@{$current->{parameter_list}}) 
    {      
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        my $constant= $current->{parameter}->{$param}->{attributes}->{constant};
        next if $tpl ne "";
        $to = "$to<$tpl> " unless $tpl eq "";
        my $magto = $to;
        $magto = $magtype{$to} if $magtype{$to};
        $from = $magtype{$from} if $magtype{$from};
        print "$to\n";
        if ($constant eq "yes" ) 
        {
            if ($direct{$to}) {
                print "$direct{$to}\n";
            }
            else {
        	    print "$sep\n\t$member\_(Translator<$from, $magto>()(\"$default\"))"; 
            }
        }
        else {
            if ($direct{$to}) {
                print "$direct{$to}\n";
            }
            else {
        	    print "$sep\n\t$member\_(Translator<$from, $magto>().magics(\"$name\"))"; 
            }
        }
		$sep = ",";
        
        
    }
	print "\n";
    print <<EOF;
{
EOF
   foreach  my $param (@{$current->{parameter_list}}) 
    {   
    	my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        next if $tpl eq "";
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $method = ucfirst $member;
        
        $to = "$to<$tpl> " unless $tpl eq "";
        my $magto = $to;
        $magto = $magtype{$to} if $magtype{$to};
        $from = $magtype{$from} if $magtype{$from};
        print "\n\tTranslator<string, $magto> $member;\n";
        print "\tset$method($member.magics(\"$name\"));\n";
       
		
   }
   print <<EOF;
} 


$header
$object\Attributes$p\::~$object\Attributes()
{
}

$header    
EOF
	$val = 0;
	  my $code = "";
    foreach  my $param (@{$current->{parameter_list}}) 
    {
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        my $xml = $current->{parameter}->{$param}->{attributes}->{xml};
        
        $to = "$to<$tpl> " unless $tpl eq "";
        my $magto = $to;
      
        my $method = ucfirst $member;
        $magto = $magtype{$to} if $magtype{$to};
        $from = $magtype{$from} if $magtype{$from};

        if ( $basetype{$to} ) 
        {
        	$code = "$code\tval = params.find(\"$name\");\n";
        	$code = "$code\tif ( val != params.end() ) { \n";
            $code = "$code\t\tset$method(Translator<string, $magto>()(val->second));\n"; 
            $code = "$code\t}\n";
        }
        elsif ( $to eq 'Colour')
        {
           $code = "$code\tval = params.find(\"$name\");\n";
           $code = "$code\tif ( val != params.end() ) { \n";
           $code = "$code\t\t$magto* $member = Translator<string, $magto>()(val->second);\n";
           $code = "$code\t\tset$method($member);\n";
           #print "\t\t$member->set(params);\n";
           
		   $code = "$code\t}\n";
           
        }
       
      
        if ( $xml ne "" && $xml ne $name) {
        	
            	#print "\t\tLog::info() << \"Parameter $name set to \" << val->second << \"\\n\"; \n";
        	if ( $basetype{$to} ) 
            { 
            	
          		$code = "$code\tval = params.find(\"$xml\");\n";
            	$code = "$code\tif ( val != params.end() ) { \n";
                 $code = "$code\t\tset$method(Translator<string, $magto>()(val->second));\n"; 
                 $code = "$code\t}\n";
            }
            elsif ( $to eq 'Colour')   {
            	$code = "$code\tval = params.find(\"$xml\");\n";
            	$code = "$code\tif ( val != params.end() ) { \n";
               $code = "$code\t\t$magto* $member = Translator<string, $magto>()(val->second);\n";
           	   $code = "$code\t\tset$method($member);\n";
           	   #print "\t\t$member->set(params);\n";
           	   $code = "$code\t}\n";
            }
            
            
        }
       
    }
        
 if ($code eq "") {
 	print "void $object\Attributes$p\::set(const std::map<string, string>&)\n{\n}\n";
 }
 else {
 	print "void $object\Attributes$p\::set(const std::map<string, string>& params)\n{\n";
 	print "\tstd::map<string, string>::const_iterator val;\n\n";
 	print "$code}\n"
 } 
 
 
     
 

        	
print  <<EOF;
$header
void $object\Attributes$p\::copy(const $object\Attributes& other)
{
EOF

    foreach  my $param (@{$current->{parameter_list}}) 
    {
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        my $xml = $current->{parameter}->{$param}->{attributes}->{xml};
         my $xml_data = $current->{attributes}->{xml_data};
        $to = "$to<$tpl> " unless $tpl eq "";
        my $magto = $to;
        my $method = ucfirst $member;
        $magto = $magtype{$to} if $magtype{$to};
        $from = $magtype{$from} if $magtype{$from};
        
        if ( $basetype{$to} ) 
        {         	
             print "\t$member\_ = other.$member\_;\n"; 
        }
        else 
        {
           print "\tset$method(other.$member\_->clone());\n";          
        }
       
        print "";
       
        
    }
     print  <<EOF;
} 

$header
void $object\Attributes$p\::set(const XmlNode& node)
{
	set(node.attributes());
EOF
	if ($xml_data ne '') {
		print "\n\tfor (XmlNode::DataIterator data = node.firstData(); data != node.lastData(); ++data)\n";
		print "\t\tsetXmlData(*data);\n";	
	}
	print "\n";
	print "\tfor (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {\n";
    		foreach  my $param (@{$current->{parameter_list}}) {
    			 my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
    			next if $todo eq 'no';
    			my $to = $current->{parameter}->{$param}->{attributes}->{to};
    			next if $basetype{$to};
    			next if $classtype{$to};
    			my $member = $current->{parameter}->{$param}->{attributes}->{member};
    			my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
    			$to = "$to<$tpl> " unless $tpl eq "";
    			my $magto = $to;
        		my $method = ucfirst $member;
        		$magto = $magtype{$to} if $magtype{$to};
    			
    			print "\t\ttry {\n";
    			print "\t\t\t$magto* $member = Translator<string, $magto>()((*elt)->name());\n";
    			print "\t\t\t$member->set(*(*elt));\n";
                print "\t\t\tset$method($member);\n";
    			print "\t\t}\n";
    			print "\t\tcatch (NoFactoryException& e) {}\n";
       
    	}
    
	

print <<EOF; 		
	}
}
$header
void $object\Attributes$p\::print(ostream& out)  const
{
	out << "$object\Attributes[";
EOF
    $sep = "";
    foreach  my $param (@{$current->{parameter_list}}) 
    {      
         my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
       next if $todo eq 'no';
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
       
       
        $to = "$to<$tpl> " unless $tpl eq "";
        $print = "$member\_";
        $print = "*$member\_" unless  $basetype{$to} ;
        
        print "\tout << \"$sep$member = \" << $print;\n"; 
        
        $sep = ", ";
        
    }
        
    print "\tout << \"]\" << \"\\n\";\n";
    print "}\n\n";
    print <<EOF; 
$header
void $object\Attributes$p\::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "\t";
	
	out << tab << "<" << tag << "\\n";
EOF
    $sep = " ";
     my $calls = "";
    
    foreach  my $param (@{$current->{parameter_list}}) 
    {
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $to = $current->{parameter}->{$param}->{attributes}->{to};
        my $tpl = $current->{parameter}->{$param}->{attributes}->{template};
        my $xml = $current->{parameter}->{$param}->{attributes}->{xml};
         $xml = $name if $xml eq '';
         my $xml_data = $current->{attributes}->{xml_data};
        $to = "$to<$tpl> " unless $tpl eq "";
        my $magto = $to;
        my $method = ucfirst $member;
        $magto = $magtype{$to} if $magtype{$to};
        $from = $magtype{$from} if $magtype{$from};
       
        if ( $basetype{$to}  ) 
        {         	
             print "\tout << tab << \"\\t$xml = \\\'\" << $member\_ << \"\\\'\\n\";\n"; 
        }
        elsif ( $classtype{$to} ) {
        	print "\tout << tab << \"\\t$xml = \\\'\" << *$member\_ << \"\\\'\\n\";\n"; 
        }
        else {
        	 $calls = "$calls \t$member\_->toxml(out, tabs+1);\n";
        	
        }
       
        
      
        print "";

    }
    print "\tout << tab << \">\";\n\n";
    print $calls;
    
    print "\n\tout << tab << \"</\" << tag << \">\\n\";\n";

  
        
    
    print "}\n\n";
    
    foreach  my $param (@{$current->{parameter_list}}) 
    {     
         my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
       next if $todo eq 'no';
        my $name = $current->{parameter}->{$param}->{attributes}->{name};
        my $member = $current->{parameter}->{$param}->{attributes}->{member};
        my $from = $current->{parameter}->{$param}->{attributes}->{from};
        my $default = $current->{parameter}->{$param}->{attributes}->{default};
        my $migration = $current->{parameter}->{$param}->{migration}->{data};
        $from = $magtype{$from} if $magtype{$from};
        
        
        $default = "\"$default\"" if  $quote{$from} ;
     
        print <<EOF
static MagicsParameter<$from> $name("$name", $default, "$migration");
EOF
        
    }
   
 
        
    
       
    foreach  my $param (@{$current->{parameter_list}}) 
    {     
        my $todo = $current->{parameter}->{$param}->{attributes}->{implemented};
        next if $todo eq 'no';
       
       
        foreach  my $option (@{$current->{parameter}->{$param}->{option_list}}) { 
        	my $include = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{include};
        	my $template = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{template};
        	my @templates = split("/", $template);
        	foreach my $t (@templates) { 
        		$includes_static->{$param}->{"$t.h"} = "$t.h";
        	}
        	$includes_static->{$param}->{$include} = $include unless $include eq "";
        }
       foreach  my $include (keys %{$includes_static->{$param}}) 
    	{     
        	print "#include \"$include\"\n";
    	} 
      
        foreach  my $option (@{$current->{parameter}->{$param}->{option_list}}) { 
        	my $class = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{name};
        	my $include = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{include};
        	my $fortran = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{fortran};
        	my $template = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{template};
        	my $xml = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{xml};
        	my $base = $current->{parameter}->{$param}->{attributes}->{to};  
        	my $templates = $current->{parameter}->{$param}->{option}->{$option}->{attributes}->{template};
        	if ($template eq "") {
        	print "static SimpleObjectMaker<$class, $base> $fortran\_$class(\"$fortran\");\n" if $fortran ne "";
        	print "static SimpleObjectMaker<$class, $base> $xml\_$class(\"$xml\");\n" if $xml ne "" && $xml ne $fortran;
        	}
        	else {
        		my @templates = split("/", $template);	
        		for my $t (@templates) {
        			print "static SimpleObjectMaker<$class<$t>, $base<$t> > $fortran\_$class\_$t(\"$fortran\");\n" if $fortran ne "";
        	        print "static SimpleObjectMaker<$class<$t>, $base<$t> > $xml\_$class\_$t(\"$xml\");\n" if $xml ne "" && $xml ne $fortran;
        		}
        	}
        }
       
    }
}


