/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLNode.h
    \brief Definition of an OpenGLNode class.
    \author Graphics Section, ECMWF

    Started: March 2008
*/

#ifndef _OpenGLNode_H
#define _OpenGLNode_H

#include <iostream>
#include <vector>
#include <map>
#include <list>

#include <OpenGLBaseRenderObject.h>

using namespace std;

namespace magics {

class OpenGLNodeVisitor;

	
class OpenGLNode : public OpenGLBaseRenderObject
{	
public:	
	OpenGLNode() : classType_("OpenGLNode"), level_(0), parent_(0) {};
	OpenGLNode(string n) : OpenGLBaseRenderObject(n), classType_("OpenGLNode"), level_(0), parent_(0) {};
	virtual ~OpenGLNode();
	
	void free();

	void level(int i) {level_=i;};
	int  level() {return level_;};	
	
	//void name(string s) {name_=s;};
	//string name() {return name_;};
		
	string classType() {return classType_;}; 

	bool accept(OpenGLNodeVisitor& v); 
		
	void addNode(OpenGLNode*);
	void deleteNode(string);
	void deleteChildren();
	void print();
	void printChildren();
	void printData();	
	void find(string,list<OpenGLNode*>&);
	void findLayout(list<OpenGLNode*>&);
	void findMagnifierLayout(list<OpenGLNode*>&);
	void findPreviewLayout(list<OpenGLNode*>&);
	void findPage(list<OpenGLNode*>&);
	void findFrame(list<OpenGLNode*>&);
	void findStep(list<OpenGLNode*>&);
	void findLayer(list<OpenGLNode*>&);
	void findLayer(OpenGLNode** ,string);

	void parent(OpenGLNode* p) {parent_=p;};
	OpenGLNode* parent() {return parent_;};

	int numOfChildren() {return children_.size();};

	bool isLeaf() {return children_.size() == 0;};
	bool hasChild() {return children_.size() > 0;};

	typedef vector<OpenGLNode*>::iterator NodeIterator;
	NodeIterator firstNode()  { return children_.begin(); }
	NodeIterator lastNode()   { return children_.end(); } 

	const vector<OpenGLNode*>& children() {return children_;};
	
protected:
	string classType_;
	//string name_;
	int level_;
	OpenGLNode* parent_;

	vector<OpenGLNode*> children_;
};


class OpenGLNodeVisitor
{
public:
	virtual ~OpenGLNodeVisitor() {};
	virtual void visit(OpenGLNode&)=0;
	virtual bool visitEnter(OpenGLNode&) {return true;};
	virtual bool visitLeave(OpenGLNode&) {return true;};
	 
};	

}

#endif
