/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLAreaGroup.h
    \brief Definition of OpenGLAreaGroup.
    \author Graphics Section, ECMWF

    Started: May 2009
*/

#include <OpenGLAreaGroup.h>

using namespace magics; 


OpenGLAreaGroup::OpenGLAreaGroup(float xmin, float xmax, float ymin, float ymax,int nx=10, int ny=10) :
		xmin_(xmin), xmax_(xmax), ymin_(ymin), ymax_(ymax), nx_(nx), ny_(ny)
{
	float dx=(xmax_-xmin_)/nx;
	float dy=(ymax_-ymin_)/ny;

	for(unsigned int i=0; i < nx_; i++)
	{
		for(unsigned int j=0; j < ny_; j++)
		{
			float x=xmin_+i*dx;
			float y=ymin_+j*dy;

			OpenGLAreaGroupItem *area= new OpenGLAreaGroupItem(x,y,dx,dy);
			push_back(area);
		}
	}
}

OpenGLAreaGroup::~OpenGLAreaGroup()
{
	for(AreaGroupIterator it=begin(); it != end(); it++)
	{
		delete *it;
	}		
}


OpenGLAreaGroupItem*  OpenGLAreaGroup::groupItem(float x, float y)
{	
	for(AreaGroupIterator it=begin(); it != end(); it++)
	{
		if((*it)->checkPointInBox(x,y))
		{
			return *it;
		}
	}

	return 0;
}


void OpenGLAreaGroup::addItemIndex(unsigned int idx,float x,float y)
{
	OpenGLAreaGroupItem *item=groupItem(x,y);
	if(item)
	{
		item->push_back(idx);
	}
}


void OpenGLAreaGroup::clearItemIndex()
{
	for(AreaGroupIterator it=begin(); it != end(); it++)
	{
		(*it)->clear();
	}		
}

void OpenGLAreaGroup::findAreas(float x,float y,float w,float h,std::set<int>& idx)
{
	OpenGLBox box(x,y,w,h);
	
	int i=0;
	for(AreaGroupIterator it=begin(); it != end(); it++)
	{
		if((*it)->checkBoxSection(&box))
		{
			idx.insert(i);
		}
		i++;
	}
}
