/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file PositionListAxisMethodAttributes.cc
    \brief Implemtation of PositionListAxisMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:46 2012
*/    

#include "PositionListAxisMethodAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


PositionListAxisMethodAttributes::PositionListAxisMethodAttributes():
	positions_(MagTranslator<floatarray, floatarray>().magics("axis_tick_position_list"))
{
} 



PositionListAxisMethodAttributes::~PositionListAxisMethodAttributes()
{
}

    
void PositionListAxisMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "axis";

	setAttribute(prefix, "axis_tick_position_list", positions_, params);
}

void PositionListAxisMethodAttributes::copy(const PositionListAxisMethodAttributes& other)
{
	positions_ = other.positions_;
} 


bool PositionListAxisMethodAttributes::accept(const string& node)
{	
	if ( magCompare(node, "control")  )
		return true;
	return false;
}

void PositionListAxisMethodAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "control") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void PositionListAxisMethodAttributes::print(ostream& out)  const
{
	out << "PositionListAxisMethodAttributes[";
	out << "positions = " << positions_;
	out << "]" << "\n";
}


void PositionListAxisMethodAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"control\"";
	 out << ", \"axis_tick_position_list\":";
	 niceprint(out,positions_);
}
static MagicsParameter<floatarray> axis_tick_position_list("axis_tick_position_list", floatarray(), "Units have changed from 'cm' to user coordinates");
