/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file PolyShadingTechniqueAttributes.h
    \brief Definition of PolyShadingTechnique Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef PolyShadingTechniqueAttributes_H
#define PolyShadingTechniqueAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "PolyShadingMethod.h"

namespace magics {

class XmlNode;


template <class P>
class PolyShadingTechniqueAttributes 
{
public:
//  --  constructor
    PolyShadingTechniqueAttributes();
    
//  --  destructor
    virtual ~PolyShadingTechniqueAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const PolyShadingTechniqueAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Method used for shading (DOT/ AREA_FILL/ HATCH) 
    \param method Setting contour_shade_method - default=dot
*/
	void setMethod(PolyShadingMethod<P> * method) 
		{ auto_ptr<PolyShadingMethod<P> > tmp(method); method_ = tmp; } 
	const PolyShadingMethod<P> &  getMethod() const 
		{ return *method_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<PolyShadingMethod<P> > method_;

private:
  
	friend ostream& operator<<(ostream& s,const PolyShadingTechniqueAttributes<P>& p)
	{ p.print(s); return s; }
};

} // namespace magics
#include "PolyShadingTechniqueAttributes.cc" 

#endif
