/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HatchPolyShadingMethodAttributes.h
    \brief Definition of HatchPolyShadingMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef HatchPolyShadingMethodAttributes_H
#define HatchPolyShadingMethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class HatchPolyShadingMethodAttributes 
{
public:
//  --  constructor
    HatchPolyShadingMethodAttributes();
    
//  --  destructor
    virtual ~HatchPolyShadingMethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const HatchPolyShadingMethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief The hatching pattern(s) to use. 0 Provides an automatic sequence of patterns, other values set a constant pattern across all contour bands.
    \param index Setting contour_shade_hatch_index - default=0
*/
	void setIndex(int index) 
		{ index_ =  index; } 
	int getIndex() const 
		{ return index_; } 
        
/*!
    Magics Information:
    \brief  Thickness of hatch lines 
    \param thickness Setting contour_shade_hatch_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief  Number of hatch lines per cm. 
    \param density Setting contour_shade_hatch_density - default=18.0
*/
	void setDensity(double density) 
		{ density_ =  density; } 
	double getDensity() const 
		{ return density_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	int index_;
	int thickness_;
	double density_;

private:
  
	friend ostream& operator<<(ostream& s,const HatchPolyShadingMethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
