/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotVisualiserAttributes.cc
    \brief Implemtation of BoxPlotVisualiser Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:46 2012
*/    

#include "BoxPlotVisualiserAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotVisualiserAttributes::BoxPlotVisualiserAttributes():
	box_(MagTranslator<string, NoBoxPlotBox>().magics("boxplot_box")),
	whisker_(MagTranslator<string, NoBoxPlotWhisker>().magics("boxplot_whisker"))
{
} 



BoxPlotVisualiserAttributes::~BoxPlotVisualiserAttributes()
{
}

    
void BoxPlotVisualiserAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(0);

	setMember(prefix, "boxplot_box", box_, params);
	setMember(prefix, "boxplot_whisker", whisker_, params);
}

void BoxPlotVisualiserAttributes::copy(const BoxPlotVisualiserAttributes& other)
{
	setBox(other.box_->clone());
	setWhisker(other.whisker_->clone());
} 


bool BoxPlotVisualiserAttributes::accept(const string& node)
{	
	if ( magCompare(node, "boxplot")  )
		return true;

	if ( acceptNode(node, box_) )
		return true;

	if ( acceptNode(node, whisker_) )
		return true;
	return false;
}

void BoxPlotVisualiserAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "boxplot") )
		set(node.attributes());
	else {
		setMember(node.name(), box_, node);
		setMember(node.name(), whisker_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), box_, *(*elt)); 
		setMember((*elt)->name(), whisker_, *(*elt)); 
	}
}

void BoxPlotVisualiserAttributes::print(ostream& out)  const
{
	out << "BoxPlotVisualiserAttributes[";
	out << "box = " << *box_;
	out << ", whisker = " << *whisker_;
	out << "]" << "\n";
}


void BoxPlotVisualiserAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"boxplot\"";
	 out << ", \"boxplot_box\":";
	 box_->toxml(out, 0);
	 out << ", \"boxplot_whisker\":";
	 whisker_->toxml(out, 0);
}
static MagicsParameter<string> boxplot_box("boxplot_box", "on", "");
static MagicsParameter<string> boxplot_whisker("boxplot_whisker", "line", "");
#include "BoxPlotItem.h"
#include "BoxPlotBasicItem.h"
static SimpleObjectMaker<BoxPlotBox, NoBoxPlotBox> on_BoxPlotBox("on");
static SimpleObjectMaker<BoxPlotBox, NoBoxPlotBox> box_BoxPlotBox("box");
static SimpleObjectMaker<NoBoxPlotBox, NoBoxPlotBox> off_NoBoxPlotBox("off");
static SimpleObjectMaker<NoBoxPlotBox, NoBoxPlotBox> noBox_NoBoxPlotBox("noBox");
#include "BoxPlotItem.h"
#include "BoxPlotBasicItem.h"
static SimpleObjectMaker<BoxPlotWhiskerBox, NoBoxPlotWhisker> box_BoxPlotWhiskerBox("box");
static SimpleObjectMaker<BoxPlotWhiskerBox, NoBoxPlotWhisker> whiskerbox_BoxPlotWhiskerBox("whiskerbox");
static SimpleObjectMaker<NoBoxPlotWhisker, NoBoxPlotWhisker> off_NoBoxPlotWhisker("off");
static SimpleObjectMaker<NoBoxPlotWhisker, NoBoxPlotWhisker> nowhisker_NoBoxPlotWhisker("nowhisker");
static SimpleObjectMaker<BoxPlotWhiskerLine, NoBoxPlotWhisker> line_BoxPlotWhiskerLine("line");
static SimpleObjectMaker<BoxPlotWhiskerLine, NoBoxPlotWhisker> whiskerline_BoxPlotWhiskerLine("whiskerline");
