/*! \file ThinningMethod.h
    \brief Definition of the Template class ThinningMethod.
    
    Magics Team - ECMWF 2010
    
    Started: Thu 28-Oct-2010
    
    Changes:
    
*/

#ifndef ThinningMethod_H
#define ThinningMethod_H

#include "magics.h"
#include "MagTranslator.h"
#include "Factory.h"

#include "CustomisedPoint.h"
#include "Transformation.h"


namespace magics {

template <class P> class Data;
class UserPoint;
class GeoPoint;

struct ThinningMethodUI {
	int nbPoints_; // For automatic Method
	int factor_;
	bool rawOnly_;
};

class ThinningMethod {

public:
	ThinningMethod();
	virtual ~ThinningMethod();
    
	void set2D() { twoD_ = false; }
	
	virtual void set(const ThinningMethodUI&) {}
	virtual void operator()(Data<GeoPoint>&, const Transformation&, const std::set<string>&, CustomisedPointsList&);
	virtual void operator()(Data<UserPoint>&, const Transformation&, const std::set<string>&, CustomisedPointsList&);
	double units() const { return units_; }
	void units(double units) const { units_ = units; }
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	 bool twoD_;
	 mutable double units_;
private:
    //! Copy constructor - No copy allowed
	ThinningMethod(const ThinningMethod&);
    //! Overloaded << operator to copy - No copy allowed
	ThinningMethod& operator=(const ThinningMethod&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const ThinningMethod& p)
		{ p.print(s); return s; }

};

class AutomaticThinningMethod: public ThinningMethod
{
public:
	AutomaticThinningMethod();
	virtual ~AutomaticThinningMethod();
	
	virtual void set(const ThinningMethodUI&);
	virtual void operator()(Data<GeoPoint>&, const Transformation&, const std::set<string>&, CustomisedPointsList&);
	virtual void operator()(Data<UserPoint>&, const Transformation&, const std::set<string>&, CustomisedPointsList&);
	int points() const { return nbPoints_; }
	void points(int points) { nbPoints_ = points; }
	bool rawOnly() const { return rawOnly_; }
protected: 
	int nbPoints_;
	bool rawOnly_;
};

class BasicThinningMethod: public ThinningMethod
{
public:
	BasicThinningMethod();
	virtual ~BasicThinningMethod();
	
	virtual void set(const ThinningMethodUI&);
	virtual void operator()(Data<GeoPoint>&, const Transformation&, const std::set<string>&, CustomisedPointsList&);
    virtual void operator()(Data<UserPoint>&, const Transformation&, const std::set<string>&, CustomisedPointsList&);
    int factor() const { return factor_; }
    void factor(int factor) { factor_ = factor; }
protected: 
	int factor_;
};

template <>
class MagTranslator<string, ThinningMethod> { 
public:
	ThinningMethod* operator()(const string& val )
	{
		return SimpleObjectMaker<ThinningMethod>::create(val);
	}     

	ThinningMethod* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif
