/*
madman - a music manager
Copyright (C) 2003  Andreas Kloeckner <ak@ixion.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/




#ifndef _HEADER_SEEN_MADMANWEB_H
#define _HEADER_SEEN_MADMANWEB_H




#include <fstream>
#include <memory>

#include "httpd.h"
#include "ui/program_interface.h"
#include "madmanweb_external.h"




class tHttpResponderUsingData : public tHttpResponder, public tProgramInterface
{
    tProgramInterface	*Interface;

  public:
    tHttpResponderUsingData()
      : Interface(NULL)
      { }

    void setProgramInterface(tProgramInterface *interface)
    {
      Interface = interface;
    }

  protected:
    void setStatus(const QString &status)
    {
      if (Interface)
	Interface->setStatus(status);
      else
	throw tRuntimeError("Program interface unavailable");
    }
    QSettings &settings()
    {
      if (Interface)
	return Interface->settings();
      else
	throw tRuntimeError("Program interface unavailable");
    }
    tDatabase &database()
    {
      if (Interface)
	return Interface->database();
      else
	throw tRuntimeError("Program interface unavailable");
    }
    tPreferences &preferences()
    {
      if (Interface)
	return Interface->preferences();
      else
	throw tRuntimeError("Program interface unavailable");
    }
    void quitApplication()
    {
      if (Interface)
	Interface->quitApplication();
      else
	throw tRuntimeError("Program interface unavailable");
    }
};




class tHttpFileResponseSender : public tHttpResponseSender
{
    auto_ptr<ifstream>	File;
    unsigned 		SizeOfSentDocument, TotalSize;

    typedef tHttpResponseSender super;

  public:
    tHttpFileResponseSender(ifstream *file);
    void setHeader(tHttpResponseHeader &header);
    void readyToSend();
};




class tHttpBufferResponseSender : public tHttpResponseSender
{
    const char		*Buffer;
    unsigned		BufferLength;
    unsigned 		SizeOfSentDocument;

    typedef tHttpResponseSender super;

  public:
    tHttpBufferResponseSender(const char *buffer, unsigned length);
    void setHeader(tHttpResponseHeader &header);
    void readyToSend();
};




class tStreamingHttpResponder : public tHttpResponderUsingData
{
  public:
    bool canHandle(const QUrl &url, QHttpRequestHeader &header);
    void handle(const QUrl &url, const QHttpRequestHeader &header, QSocket *&socket);
};




class tStaticDataHttpResponder : public tHttpResponder
{
  public:
    bool canHandle(const QUrl &url, QHttpRequestHeader &header);
    void handle(const QUrl &url, const QHttpRequestHeader &header, QSocket *&socket);
};




class tBrowseHttpResponder : public tHttpResponderUsingData
{
  public:
    QString getTitleCell(const QUrl &url, const QString &human_readable, const QString &machine_readable);
    QString getTitleRow(const QUrl &url);
    QString getSongRow(tSong *song, bool bright);
    QString generateMenu(const QUrl &url);

    bool canHandle(const QUrl &url, QHttpRequestHeader &header);
    void handle(const QUrl &url, const QHttpRequestHeader &header, QSocket *&socket);
};




class tScriptingHttpResponder : public tHttpResponderUsingData
{
  public:
    bool canHandle(const QUrl &url, QHttpRequestHeader &header);
    void handle(const QUrl &url, const QHttpRequestHeader &header, QSocket *&socket);
};




#endif
