/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: listen.h,v 1.11 2004/10/05 14:06:37 chaoron Exp $
 *
 ***************************************************************************/

#ifndef ZORP_LISTEN_H_INCLUDED
#define ZORP_LISTEN_H_INCLUDED

#include <zorp/zorplib.h>
#include <zorp/sockaddr.h>
#include <zorp/socket.h>

#ifdef __cplusplus
extern "C" {
#endif

/* z_io_listen public interface */

/*+

  Listen on the given socket address, and call a given callback for
  each incoming connection.

  +*/
typedef struct _ZIOListen 
{
  ZSockAddr *local;
  gint fd;
} ZIOListen;

typedef gboolean (*ZAcceptFunc)(int fd, ZSockAddr *client, gboolean last_connection, gpointer user_data);

ZIOListen *
z_io_listen_new(const gchar *session_id,
                ZSockAddr *local,
		guint32 sock_flags,
		gint backlog,
		ZAcceptFunc callback,
		gpointer user_data);

void z_io_listen_ref(ZIOListen *l);
void z_io_listen_unref(ZIOListen *l);
void z_io_listen_start(ZIOListen *self);
void z_io_listen_cancel(ZIOListen *l);

void z_io_listen_suspend(ZIOListen *l);
void z_io_listen_resume(ZIOListen *l);

G_CONST_RETURN gchar *z_io_listen_get_session(ZIOListen *l);

#ifdef __cplusplus
}
#endif

#endif
