/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: ssl.h,v 1.6.2.1 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SSL_H_INCLUDED
#define ZORP_SSL_H_INCLUDED

#include <openssl/ssl.h>
#include <zorp/zorplib.h>
#include <zorp/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ZSSLSession 
{
  guint ref_cnt;
  SSL *ssl;
  gchar *session_id;
  gint verify_type;
  gint verify_depth;
  X509_STORE *crl_store;
} ZSSLSession;

#define Z_SSL_MODE_CLIENT  0
#define Z_SSL_MODE_SERVER  1

#define Z_SSL_VERIFY_NONE                0
#define Z_SSL_VERIFY_OPTIONAL            1
#define Z_SSL_VERIFY_REQUIRED_UNTRUSTED  2
#define Z_SSL_VERIFY_REQUIRED_TRUSTED    3


void z_ssl_init(void);
void z_ssl_destroy(void);

ZSSLSession *
z_ssl_session_new(char *session_id, 
                  int mode,
                  gchar *key_file, 
                  gchar *cert_file, 
                  gchar *ca_dir, 
                  gchar *crl_dir, 
                  int verify_depth,
                  int verify_type);

ZSSLSession *z_ssl_session_new_ssl(SSL *ssl);

ZSSLSession *z_ssl_session_ref(ZSSLSession *self);
void z_ssl_session_unref(ZSSLSession *self);

gchar *z_ssl_get_error_str(gchar *buf, int buflen);

BIO *z_ssl_bio_new(ZStream *stream);

#ifdef __cplusplus
}
#endif

#endif
