/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: misc.h,v 1.10.2.7 2003/07/07 17:31:49 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_MISC_H_INCLUDED
#define ZORP_MISC_H_INCLUDED

#include <sys/types.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ZCharSet
{
  guint32 enable_mask[256 / 32];
} ZCharSet;

void z_charset_init(ZCharSet *self);
gboolean z_charset_parse(ZCharSet *self, gchar *spec);
gboolean z_charset_is_string_valid(ZCharSet *self, gchar *str, gint len);

static inline void 
z_charset_enable(ZCharSet *self, char chr)
{
  guint ndx = ((guchar) chr) >> 5;
  guint bit = 1 << (((guchar) chr) & 0x1F);
  
  self->enable_mask[ndx] |= bit;
}

static inline gboolean
z_charset_is_enabled(ZCharSet *self, char chr)
{
  guint ndx = ((guchar) chr) >> 5;
  guint bit = 1 << (((guchar) chr) & 0x1F);
  
  return !!(self->enable_mask[ndx] & bit);
}

void z_data_dump(char *session_id, const char *buf, guint len);

GString *g_string_assign_len(GString *s, gchar *val, gint len);

gchar *z_str_escape(const gchar *s, gint len);
gchar *z_str_compress(const gchar *s, gint len);

gboolean z_port_enabled(gchar *port_range, guint port);

void z_crypt(const char *key, const char *salt, char *result, size_t result_len);


gchar *z_zorplib_version_info(void);

#ifdef __cplusplus
}
#endif

#endif
