/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: streamline.h,v 1.8.2.3 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_READLINE_H_INCLUDED
#define ZORP_READLINE_H_INCLUDED

#include <zorp/zorplib.h>
#include <zorp/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

#define ZRL_EOL_NL		0x00000001 /* end-of-line is indicated by nl */
#define ZRL_EOL_CRLF		0x00000002 /* end-of-line is indicated by crlf pair */
#define ZRL_EOL_FATAL		0x00000004 /* erroneous eol mark is fatal */
#define ZRL_NUL_NONFATAL        0x00000008 /* embedded NUL character is not fatal */

#define ZRL_TRUNCATE		0x00000010 /* truncate if line longer than buffer */
#define ZRL_SPLIT		0x00000020 /* split line if longer than buffer */
#define ZRL_SINGLE_READ		0x00000040 /* don't issue several read()s when fetching a line */
#define ZRL_PARTIAL_READ	0x00000080 /* call read callback even if no end-of-line available */

#define ZST_LINE_GET_TRUNCATE     (0x01) | ZST_LINE
#define ZST_LINE_GET_SPLIT        (0x02) | ZST_LINE
#define ZST_LINE_GET_SINGLE_READ  (0x03) | ZST_LINE
#define ZST_LINE_GET_PARTIAL_READ (0x04) | ZST_LINE

#define ZST_LINE_SET_TRUNCATE     (0x11) | ZST_LINE
#define ZST_LINE_SET_SPLIT        (0x12) | ZST_LINE
#define ZST_LINE_SET_SINGLE_READ  (0x13) | ZST_LINE
#define ZST_LINE_SET_PARTIAL_READ (0x14) | ZST_LINE

#ifdef __cplusplus
}
#endif

GIOStatus z_stream_line_get(ZStream *s, char **line, guint *length, GError **error);
GIOStatus z_stream_line_get_copy(ZStream *s, char *line, guint *length, GError **error);
void z_stream_line_unget_line(ZStream *stream);

ZStream *z_stream_line_new(ZStream *from, guint bufsize, guint flags);

static inline void
z_stream_line_set_partial_read(ZStream *stream, gboolean enable)
{
  z_stream_ctrl(stream, ZST_LINE_SET_PARTIAL_READ, &enable, sizeof(enable));
}

static inline void
z_stream_line_permit_long_line(ZStream *stream, gboolean enable)
{
  z_stream_ctrl(stream, ZST_LINE_SET_SPLIT, &enable, sizeof(enable));
}

#endif
