/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: streambuf.h,v 1.5.2.2 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_STREAMBUF_H_INCLUDED
#define ZORP_STREAMBUF_H_INCLUDED

#include <zorp/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*stream_buf_writeable)(ZStream *stream, gpointer user_data);
typedef gboolean (*stream_buf_error)(ZStream *stream, GIOStatus  status, gpointer  user_data);

ZStream *z_stream_buf_new(ZStream *stream,
                            guint  min_threshold,
                            guint  max_threshold,
             stream_buf_writeable  writeable_callback,
                 stream_buf_error  error_callback);

GIOStatus z_stream_write_buf(ZStream *stream,
                               gchar *buf,
                               guint  buflen,
                            gboolean  must_copy,
                            gboolean  urgent);

#ifdef __cplusplus
}
#endif

#endif
