#ifndef ZORP_STACKDUMP_H_INCLUDED
#define ZORP_STACKDUMP_H_INCLUDED

#include <zorp/zorplib.h>

#ifdef __cplusplus
extern "C" {
#endif

#if ZORPLIB_ENABLE_STACKDUMP
typedef struct sigcontext ZSignalContext;
#else
typedef void ZSignalContext;
#endif

/* 
 * Return the current signal context used for stack dumping.
 * The variable passed as parameter must be declared in a signal handler.
 */

#define z_stackdump_get_context(p) \
  (ZSignalContext *) (((char *) &p) + 16)

void z_stackdump_log(ZSignalContext *context);

#ifdef __cplusplus
}
#endif

#endif
