/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: listen.h,v 1.7.2.1 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_LISTEN_H_INCLUDED
#define ZORP_LISTEN_H_INCLUDED

#include <zorp/zorplib.h>
#include <zorp/sockaddr.h>
#include <zorp/socket.h>

#ifdef __cplusplus
extern "C" {
#endif

/* z_io_listen public interface */

/*+

  Listen on the given socket address, and call a given callback for
  each incoming connection.

  +*/
typedef struct _ZIOListen 
{
  ZSockAddr *local;
} ZIOListen;

typedef gboolean (*ZAcceptFunc)(int fd, ZSockAddr *client, gboolean last_connection, gpointer user_data);

ZIOListen *
z_io_listen_new(ZSockAddr *local, 
		     gboolean accept_one,
		     gint backlog,
		     ZAcceptFunc callback,
		     gpointer user_data);

void z_io_listen_ref(ZIOListen *l);
void z_io_listen_unref(ZIOListen *l);
void z_io_listen_start(ZIOListen *self);
void z_io_listen_cancel(ZIOListen *l);

void z_io_listen_suspend(ZIOListen *l);
void z_io_listen_resume(ZIOListen *l);

#ifdef __cplusplus
}
#endif

#endif
