/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: process.c,v 1.2.2.1 2003/05/27 19:19:58 sasa Exp $
 *
 * Author  : Bazsi, SaSa, Chaoron
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/zorplib.h>
#include <zorp/log.h>
#include <zorp/process.h>

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef HAVE_UNISTD_H
  #include <unistd.h>
#endif
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

static int filedes[2] = {-1, -1};

#ifdef G_OS_WIN32
#  include <windows.h>
#endif


#ifdef G_OS_WIN32


typedef DWORD (WINAPI *fp_RegServProc)(DWORD dwProcessId,DWORD dwType);

gboolean
z_process_daemonize(uid_t uid, gid_t gid, const gchar *pidfile)
{
  HMODULE hModule;
  fp_RegServProc regsrvproc=NULL;
  DWORD res;

  res = 0;
  hModule = GetModuleHandle(TEXT("kernel32.dll"));
  if (hModule != NULL)
    {
      regsrvproc = (fp_RegServProc)GetProcAddress(hModule,"RegisterServiceProcess");
      if (regsrvproc != NULL)
        res = (*regsrvproc) (0,1);
      FreeLibrary(hModule);
    }
  return res;

  /* void::FIXME impersonation */
}

#else

gboolean
z_process_daemonize(uid_t uid, gid_t gid, const gchar *pidfile)
{
  pid_t pid;
  FILE *fd;
  guint ret_num;
  gchar ret_buf[5];
  
  if (pipe(filedes) != 0)
    {
      /*LOG
        This message is attempt when system cannot fork.
        The possible cause is short of memory or too many
        running process.
       */
      z_log(NULL, CORE_ERROR, 0, "Error open pipe; error='%m'");
      return FALSE;
    }
  
  if ((pid = fork()) < 0)
    {
      /*LOG
        This message is attempt when system cannot fork.
        The possible cause is short of memory or too many
        running process.
       */
      z_log(NULL, CORE_ERROR, 0, "Error forking child process; error='%m'");
      return FALSE;
    }
  else if (pid != 0)
    {
      close(filedes[1]);
      memset(ret_buf, 0, sizeof(ret_buf));
      if (read(filedes[0], ret_buf, sizeof(ret_buf)) > 0)
        ret_num = atoi(ret_buf);
      else
        ret_num = 1;
      if (ret_num >= 0)
        {
          if (pidfile != NULL)
            {
              fd = fopen(pidfile, "w");
              if (fd != NULL)
                {
                  fprintf(fd, "%d\n", pid);
                  fclose(fd);
                }
              else
                {
                  /*LOG
                    This message attempt when cannot create pid file,
                    for example when cannot write to "/var/run".
                   */
                  z_log(NULL, CORE_ERROR, 4, "Error creating pid file; file='%s', error='%m'", pidfile);
                }
            }
        }
      exit(ret_num);
    }
  
  close(filedes[0]);
  if (setsid() < 0)
    {
      /*LOG
        This message attempt when cannot detach from his parent.
       */
      z_log(NULL, CORE_ERROR, 0, "Error becoming process group leader; error='%m'");
      return FALSE;
    }
    
  chdir("/");
  umask(0);
  
  if (gid != -1)
    {
      if (setgid(gid) < 0)
        {
          /*LOG
            This message attempt when cannot change to requested group.
           */
	  z_log(NULL, CORE_ERROR, 0, "Error setting group id; gid='%d', error='%m'", gid);
          return FALSE;
        }
    }

  if (uid != -1)
    {
      if (setuid(uid) < 0)
        {
          /*LOG
            This message attempt when cannot change to requested user.
           */
	  z_log(NULL, CORE_ERROR, 0, "Error setting user id; uid='%d', error='%m'", uid);
          return FALSE;
        }
    }

  close(STDIN_FILENO);
  
  return TRUE;
}

void
z_process_failed(guint ret_num)
{
  gchar buf[10];
  guint buf_len;
  
  if (filedes[1] != -1)
    {
      buf_len = g_snprintf(buf, sizeof(buf), "%d", ret_num);
      write(filedes[1], buf, buf_len);
    }
}

void
z_process_ok(void)
{
  if (filedes[1] != -1)
    write(filedes[1], "0", 1);
}

#endif
