/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: error.c,v 1.1.2.1 2003/04/11 19:15:54 sasa Exp $
 *
 * Author  : void
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <glib.h>
#include <zorp/error.h>

#ifdef G_OS_WIN32
/* it's not complete... only contains error codes used somewhere */
static int
z_errno_translate(int e)
{
  switch (e)
    {
      case EAGAIN: /* a.k.a. EWOULDBLOCK */
      case EINPROGRESS:
        return WSAEWOULDBLOCK;
      case EINTR:
        /* WSAEINTR does exist, but has a different meaning */
        return 0;
      default:
        return e;
    }
}
#endif

gboolean
z_errno_is(int e)
{
#ifdef G_OS_WIN32
  int err;
  err = WSAGetLastError();
  if ( err == z_errno_translate(e))
    return TRUE;
#endif
  return (errno == e);
}

int
z_errno_get(void)
{
#ifdef G_OS_WIN32
  return WSAGetLastError();
#else
  return errno;
#endif
}

void
z_errno_set(int e)
{
#ifdef G_OS_WIN32
  WSASetLastError(e);
#endif
  errno = e;
}
