/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: cap.c,v 1.6.2.3 2003/09/16 19:40:28 sasa Exp $
 *
 *
 * Author  : Bazsi
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/zorplib.h>
#include <zorp/cap.h>
#include <zorp/log.h>

#if ZORPLIB_ENABLE_CAPS

const gchar *zorp_caps = "cap_net_admin,cap_net_bind_service=p";

/**
 * cap_modify:
 * @capability: capability to turn off or on
 * @onoff: specifies whether the capability should be enabled or disabled
 *
 * This function modifies the current permitted set of capabilities by
 * enabling or disabling the capability specified in @capability.
 *
 * Returns: whether the operation was successful.
 **/
gboolean 
cap_modify(int capability, int onoff)
{
  cap_t caps;

  z_enter();
  if (!zorp_caps)
    {
      z_leave();
      return TRUE;
    }
  
  caps = cap_get_proc();
  if (!caps)
    {
      z_leave();
      return FALSE;
    }


  if (cap_set_flag(caps, CAP_EFFECTIVE, 1, &capability, onoff) == -1)
    {
      cap_free(caps);
      z_leave();
      return FALSE;
    }

  if (cap_set_proc(caps) == -1)
    {
      cap_free(caps);
      z_leave();
      return FALSE;
    }
  cap_free(caps);
  z_leave();
  return TRUE;
}

/**
 * cap_save:
 *
 * Save the set of current capabilities and return it. The caller might
 * restore the saved set of capabilities by using cap_restore().
 *
 * Returns: the current set of capabilities
 **/
cap_t 
cap_save(void)
{
  cap_t res;
  
  z_enter();
  if (!zorp_caps)
    {
      z_leave();
      return NULL;
    }
  res = cap_get_proc();
  z_leave();
  return res;
}

/**
 * cap_restore:
 * @r: capability set saved by cap_save()
 *
 * Restore the set of current capabilities specified by @r.
 *
 * Returns: whether the operation was successful.
 **/
gboolean
cap_restore(cap_t r)
{
  gboolean rc;

  z_enter();
  if (!zorp_caps)
    {
      z_leave();
      return TRUE;
    }
  rc = cap_set_proc(r) != -1;
  cap_free(r);
  z_leave();
  return rc;
}

#endif
