/* ***************************************************************************
 *
 * Pico Technology USBTC08 Device Driver
 *
 *//**
 * \file      lookupdatatable.h 
 * \brief     Thermocouple lookup tables for TC08
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: lookupdatatable.h,v 1.1 2007/05/14 12:36:04 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef LOOKUPDATATABLE_H
#define LOOKUPDATATABLE_H

/** The lookup data. Each element represents the microvolt value of a temperature
 * when read using the thermocouple type of that row. The start temperature and
 * increment for each thermocouple type can be found in lookupdata.h */
long ThermocoupleTable[][200]=
{{
// CJC Thermistor
1124297L,
1092852L,
1061791L,
1031147L,
1000949L,
971225L,
941999L,
913294L,
885131L,
857527L,
830497L,
804055L,
778210L,
752973L,
728348L,
704341L,
680955L,
658189L,
636044L,
614517L,
593604L,
573301L,
553600L,
534496L,
515979L,
498041L,
480672L,
463862L,
447599L,
431871L,
416668L,
401976L,
387784L,
374078L,
360845L,
348074L,
335750L,
323861L,
312394L,
301336L,
290675L,
280398L,
270493L,
260947L,
251749L,
242887L,
234350L,
226126L,
218204L,
210575L,
203227L,
196150L,
189335L,
182772L,
176452L,
170366L,
164507L,
158864L,
153430L,
148196L,
143156L,
138303L,
133628L,
129125L,
124788L,
120611L,
116586L,
112710L,
108975L,
105376L,
101908L,
98567L,
95347L,
92243L,
89252L,
86368L},{
// Type B Thermocouple
-3L,
-2L,
0L,
2L,
6L,
11L,
17L,
25L,
33L,
43L,
53L,
65L,
78L,
92L,
107L,
123L,
141L,
159L,
178L,
199L,
220L,
243L,
267L,
291L,
317L,
344L,
372L,
401L,
431L,
462L,
494L,
527L,
561L,
596L,
632L,
669L,
707L,
746L,
787L,
828L,
870L,
913L,
957L,
1002L,
1048L,
1095L,
1143L,
1192L,
1242L,
1293L,
1344L,
1397L,
1451L,
1505L,
1561L,
1617L,
1675L,
1733L,
1792L,
1852L,
1913L,
1975L,
2037L,
2101L,
2165L,
2230L,
2296L,
2363L,
2431L,
2499L,
2569L,
2639L,
2710L,
2782L,
2854L,
2928L,
3002L,
3078L,
3154L,
3230L,
3308L,
3386L,
3466L,
3546L,
3626L,
3708L,
3790L,
3873L,
3957L,
4041L,
4127L,
4213L,
4299L,
4387L,
4475L,
4564L,
4653L,
4743L,
4834L,
4926L,
5018L,
5111L,
5205L,
5299L,
5394L,
5489L,
5585L,
5682L,
5780L,
5878L,
5976L,
6075L,
6175L,
6276L,
6377L,
6478L,
6580L,
6683L,
6786L,
6890L,
6995L,
7100L,
7205L,
7311L,
7417L,
7524L,
7632L,
7740L,
7848L,
7957L,
8066L,
8176L,
8286L,
8397L,
8508L,
8620L,
8731L,
8844L,
8956L,
9069L,
9182L,
9296L,
9410L,
9524L,
9639L,
9753L,
9868L,
9984L,
10099L,
10215L,
10331L,
10447L,
10563L,
10679L,
10796L,
10913L,
11029L,
11146L,
11263L,
11380L,
11497L,
11614L,
11731L,
11848L,
11965L,
12082L,
12199L,
12316L,
12433L,
12549L,
12666L,
12782L,
12898L,
13014L,
13130L,
13246L,
13361L,
13476L,
13591L,
13706L,
13820L},{
// Type E Thermocouple
-9835L,
-9797L,
-9718L,
-9604L,
-9455L,
-9274L,
-9063L,
-8825L,
-8561L,
-8273L,
-7963L,
-7632L,
-7279L,
-6907L,
-6516L,
-6107L,
-5681L,
-5237L,
-4777L,
-4302L,
-3811L,
-3306L,
-2787L,
-2255L,
-1709L,
-1152L,
-582L,
0L,
591L,
1192L,
1801L,
2420L,
3048L,
3685L,
4330L,
4985L,
5648L,
6319L,
6998L,
7685L,
8379L,
9081L,
9789L,
10503L,
11224L,
11951L,
12684L,
13421L,
14164L,
14912L,
15664L,
16420L,
17181L,
17945L,
18713L,
19484L,
20259L,
21036L,
21817L,
22600L,
23386L,
24174L,
24964L,
25757L,
26552L,
27348L,
28146L,
28946L,
29747L,
30550L,
31354L,
32159L,
32965L,
33772L,
34579L,
35387L,
36196L,
37005L,
37815L,
38624L,
39434L,
40243L,
41053L,
41862L,
42671L,
43479L,
44286L,
45093L,
45900L,
46705L,
47509L,
48313L,
49116L,
49917L,
50718L,
51517L,
52315L,
53112L,
53908L,
54703L,
55497L,
56289L,
57080L,
57870L,
58659L,
59446L,
60232L,
61017L,
61801L,
62583L,
63364L,
64144L,
64922L,
65698L,
66473L,
67246L,
68017L,
68787L,
69554L,
70319L,
71082L,
71844L,
72603L,
73360L,
74115L,
74869L,
75621L,
76373L},{
// Type J Thermocouple
-8095L,
-7890L,
-7659L,
-7403L,
-7123L,
-6821L,
-6500L,
-6159L,
-5801L,
-5426L,
-5037L,
-4633L,
-4215L,
-3786L,
-3344L,
-2893L,
-2431L,
-1961L,
-1482L,
-995L,
-501L,
0L,
507L,
1019L,
1537L,
2059L,
2585L,
3116L,
3650L,
4187L,
4726L,
5269L,
5814L,
6360L,
6909L,
7459L,
8010L,
8562L,
9115L,
9669L,
10224L,
10779L,
11334L,
11889L,
12445L,
13000L,
13555L,
14110L,
14665L,
15219L,
15773L,
16327L,
16881L,
17434L,
17986L,
18538L,
19090L,
19642L,
20194L,
20745L,
21297L,
21848L,
22400L,
22952L,
23504L,
24057L,
24610L,
25164L,
25720L,
26276L,
26834L,
27393L,
27953L,
28516L,
29080L,
29647L,
30216L,
30788L,
31362L,
31939L,
32519L,
33102L,
33689L,
34279L,
34873L,
35470L,
36071L,
36675L,
37284L,
37896L,
38512L,
39132L,
39755L,
40382L,
41012L,
41645L,
42281L,
42919L,
43559L,
44203L,
44848L,
45494L,
46141L,
46786L,
47431L,
48074L,
48715L,
49353L,
49989L,
50622L,
51251L,
51877L,
52500L,
53119L,
53735L,
54347L,
54956L,
55561L,
56164L,
56763L,
57360L,
57953L,
58545L,
59134L,
59721L,
60307L,
60890L,
61473L,
62054L,
62634L,
63214L,
63792L,
64370L,
64948L,
65525L,
66102L,
66679L,
67255L,
67831L,
68406L,
68980L,
69553L},{
// Type K Thermocouple
-6458L,
-6441L,
-6404L,
-6344L,
-6262L,
-6158L,
-6035L,
-5891L,
-5730L,
-5550L,
-5354L,
-5141L,
-4913L,
-4669L,
-4411L,
-4138L,
-3852L,
-3554L,
-3243L,
-2920L,
-2587L,
-2243L,
-1889L,
-1527L,
-1156L,
-778L,
-392L,
0L,
397L,
798L,
1203L,
1612L,
2023L,
2436L,
2851L,
3267L,
3682L,
4096L,
4509L,
4920L,
5328L,
5735L,
6138L,
6540L,
6941L,
7340L,
7739L,
8138L,
8539L,
8940L,
9343L,
9747L, 
10153L,
10561L,
10971L,
11382L,
11795L,
12209L,
12624L,
13040L,
13457L,
13874L,
14293L,
14713L,
15133L,
15554L,
15975L,
16397L,
16820L,
17243L,
17667L,
18091L,
18516L,
18941L,
19366L,
19792L,
20218L,
20644L,
21071L,
21497L,
21924L,
22350L,
22776L,
23203L,
23629L,
24055L,
24480L,
24905L,
25330L,
25755L,
26179L,
26602L,
27025L,
27447L,
27869L,
28289L,
28710L,
29129L,
29548L,
29965L,
30382L,
30798L,
31213L,
31628L,
32041L,
32453L,
32865L,
33275L,
33685L,
34093L,
34501L,
34908L,
35313L,
35718L,
36121L,
36524L,
36925L,
37326L,
37725L,
38124L,
38522L,
38918L,
39314L,
39708L,
40101L,
40494L,
40885L,
41276L,
41665L,
42053L,
42440L,
42826L,
43211L,
43595L,
43978L,
44359L,
44740L,
45119L,
45497L,
45873L,
46249L,
46623L,
46995L,
47367L,
47737L,
48105L,
48473L,
48838L,
49202L,
49565L,
49926L,
50286L,  
50644L,
51000L,
51355L,
51708L,
52060L,
52410L, 
52759L,
53106L,
53451L,
53795L,
54138L, 
54479L, 
54819L
},{
// Type N Thermocouple
-4345L,
-4336L,
-4313L,
-4277L,
-4226L,
-4162L,
-4083L,
-3990L,
-3884L,
-3766L,
-3634L,
-3491L,
-3336L,
-3171L,
-2994L,
-2808L,
-2612L,
-2407L,
-2193L,
-1972L,
-1744L,
-1509L,
-1269L,
-1023L,
-772L,
-518L,
-260L,
0L,
261L,
525L,
793L,
1065L,
1340L,
1619L,
1902L,
2189L,
2480L,
2774L,
3072L,
3374L,
3680L,
3989L,
4302L,
4618L,
4937L,
5259L,
5585L,
5913L,
6245L,
6579L,
6916L,
7255L,
7597L,
7941L,
8288L,
8637L,
8988L,
9341L,
9696L,
10054L,
10413L,
10774L,
11136L,
11501L,
11867L,
12234L,
12603L,
12974L,
13346L,
13719L,
14094L,
14469L,
14846L,
15225L,
15604L,
15984L,
16366L,
16748L,
17131L,
17515L,
17900L,
18286L,
18672L,
19059L,
19447L,
19835L,
20224L,
20613L,
21003L,
21393L,
21784L,
22175L,
22566L,
22958L,
23350L,
23742L,
24134L,
24527L,
24919L,
25312L,
25705L,
26098L,
26491L,
26883L,
27276L,
27669L,
28062L,
28455L,
28847L,
29239L,
29632L,
30024L,
30416L,
30807L,
31199L,
31590L,
31981L,
32371L,
32761L,
33151L,
33541L,
33930L,
34319L,
34707L,
35095L,
35482L,
35869L,
36256L,
36641L,
37027L,
37411L,
37795L,
38179L,
38562L,
38944L,
39326L,
39706L,
40087L,
40466L,
40845L,
41223L,
41600L,
41976L,
42352L,
42727L,
43101L,
43474L,
43846L,
44218l,
44588L,
44958L,
45326L,
45694L,
46060L,
46425L,
46789L,
47152L,
47513L
},{
// Type R Thermocouple
-226L,
-188L,
-145L,
-100L,
-51L,
0L,
54L,
111L,
171L,
232L,
296L,
363L,
431L,
501L,
573L,
647L,
723L,
800L,
879L,
959L,
1041L,
1124L,
1208L,
1294L,
1381L,
1469L,
1558L,
1648L,
1739L,
1831L,
1923L,
2017L,
2112L,
2207L,
2304L,
2401L,
2498L,
2597L,
2696L,
2796L,
2896L,
2997L,
3099L,
3201L,
3304L,
3408L,
3512L,
3616L,
3721L,
3827L,
3933L,
4040L,
4147L,
4255L,
4363L,
4471L,
4580L,
4690L,
4800L,
4910L,
5021L,
5133L,
5245L,
5357L,
5470L,
5583L,
5697L,
5812L,
5926L,
6041L,
6157L,
6273L,
6390L,
6507L,
6625L,
6743L,
6861L,
6980L,
7100L,
7220L,
7340L,
7461L,
7583L,
7705L,
7827L,
7950L,
8073L,
8197L,
8321L,
8446L,
8571L,
8697L,
8823L,
8950L,
9077L,
9205L,
9333L,
9461L,
9590L,
9720L,
9850L,
9980L,
10111L,
10242L,
10374L,
10506L,
10638L,
10771L,
10905L,
11039L,
11173L,
11307L,
11442L,
11578L,
11714L,
11850L,
11986L,
12123L,
12260L,
12397L,
12535L,
12673L,
12812L,
12950L,
13089L,
13228L,
13367L,
13507L,
13646L,
13786L,
13926L,
14066L,
14207L,
14347L,
14488L,
14629L,
14770L,
14911L,
15052L,
15193L,
15334L,
15475L,
15616L,
15758L,
15899L,
16040L,
16181L,
16323L,
16464L,
16605L,
16746L,
16887L,
17028L,
17169L,
17310L,
17451L,
17591L,
17732L,
17872L,
18012L,
18152L,
18292L,
18431L,
18571L,
18710L,
18849L,
18988L,
19126L,
19264L,
19402L,
19540L,
19677L,
19814L,
19951L,
20087L,
20222L,
20356L,
20488L,
20620L,
20749L,
20877L,
21003L
},{
// Type S Thermocouple
-236L,
-194L,
-150L,
-103L,
-53L,
0L,
55L,
113L,
173L,
235L,
299L,
365L,
433L,
502L,
573L,
646L,
720L,
795L,
872L,
950L,
1029L,
1110L,
1191L,
1273L,
1357L,
1441L,
1526L,
1612L,
1698L,
1786L,
1874L,
1962L,
2052L,
2141L,
2232L,
2323L,
2415L,
2507L,
2599L,
2692L,
2786L,
2880L,
2974L,
3069L,
3164L,
3259L,
3355L,
3451L,
3548L,
3645L,
3742L,
3840L,
3938L,
4036L,
4134L,
4233L,
4332L,
4432L,
4532L,
4632L,
4732L,
4833L,
4934L,
5035L,
5137L,
5239L,
5341L,
5443L,
5546L,
5649L,
5753L,
5857L,
5961L,
6065L,
6170L,
6275L,
6381L,
6486L,
6593L,
6699L,
6806L,
6913L,
7020L,
7128L,
7236L,
7345L,
7454L,
7563L,
7673L,
7783L,
7893L,
8003L,
8114L,
8226L,
8337L,
8449L,
8562L,
8674L,
8787L,
8900L,
9014L,
9128L,
9242L,
9357L,
9472L,
9587L,
9703L,
9819L,
9935L,
10051L,
10168L,
10285L,
10403L,
10520L,
10638L,
10757L,
10875L,
10994L,
11113L,
11232L,
11351L,
11471L,
11590L,
11710L,
11830L,
11951L,
12071L,
12191L,
12312L,
12433L,
12554L,
12675L,
12796L,
12917L,
13038L,
13159L,
13280L,
13402L,
13523L,
13644L,
13766L,
13887L,
14009L,
14130L,
14251L,
14373L,
14494L,
14615L,
14736L,
14857L,
14978L,
15099L,
15220L,
15341L,
15461L,
15582L,
15702L,
15822L,
15942L,
16062L,
16182L,
16301L,
16420L,
16539L,
16658L,
16777L,
16895L,
17013L,
17131L,
17249L,
17366L,
17483L,
17600L,
17717L,
17832L,
17947L,
18061L,
18174L,
18285L,
18395L,
18503L,
18609L
},{
// Type T Thermocouple
-6258L,
-6232L,
-6180L,
-6105L,
-6007L,
-5888L,
-5753L,
-5603L,
-5439L,
-5261L,
-5070L,
-4865L,
-4648L,
-4419L,
-4177L,
-3923L,
-3657L,
-3379L,
-3089L,
-2788L,
-2476L,
-2153L,
-1819L,
-1475L,
-1121L,
-757L,
-383L,
0L,
391L,
790L,
1196L,
1612L,
2036L,
2468L,
2909L,
3358L,
3814L,
4279L,
4750L,
5228L,
5714L,
6206L,
6704L,
7209L,
7720L,
8237L,
8759L,
9288L,
9822L,
10362L,
10907L,
11458L,
12013L,
12574L,
13139L,
13709L,
14283L,
14862L,
15445L,
16032L,
16624L,
17219L,
17819L,
18422L,
19030L,
19641L,
20255L,
20872L
}};
#endif /* not defined LOOKUPDATATABLE_H */

