@nocode MH
= class TMail::Mail

== Class Methods

: new( port: TMail::Port = TMail::StringPort.new, config: TMail::Config = DEFAULT_CONFIG ) -> TMail::Mail
j
    port  Mail ֥Ȥޤ
e
    creates a new 'TMail::Mail' object from PORT.
.

: load( filename: String ) -> TMail::Mail
j
    ե filename ᡼ɤ Mail ֥Ȥޤ
    ɤե MH Υ᡼Τ褦˥᡼̤եҤȤĤ
    бƤʤФޤ

    ,UNIX mbox Τ褦ʷñȤǤбƤޤ
    <a href="mbox.html">᡼ܥå饹</a>ȤäƤ
e
    creates a new 'TMail::Mail' object. FILENAME is the name of file
    which contains just one mail (e.g. MH mail file).
.

: parse( str: String ) -> TMail::Mail
j
    ʸ str ѡ TMail::Mail ֥Ȥޤ
    str ϥ᡼ʬǤʤФޤ
e
    parses STR and creates a new 'TMail::Mail' object.
.

== Instance Methods

: port -> TMail::Port
j
    Υ᡼륪֥ȤΥݡȤǤ
e
    the source port of this mail.
.

: body_port -> TMail::Port
j
    ᡼ʸ¸ƤݡȤ֤ޤ

    ˽񤭤ǤɸΥե(ʸ)ѹޤ
    ºݤѹ뤿ˤϤΥݡȤ˽񤭤 #write_back Ƥ
    ɬפޤ
e
    the port to save body of this mail.
.

: each {|line| .... }
j
    ʸʸγƹԤФ뷫֤
    body_port.ropen {|f| f.each } ƱǤ
e
    iterates for each lines of mail body.
.

: body -> String
: preamble -> String
j
    ᡼ܥǥ(ʸ)ƤʸȤ֤ޤ
    MIME ޥѡȥ᡼ΤȤ preamble ޤ
    ֤ͤѹƤ⥪ꥸʥѹޤ
e
    the mail body. If the mail is a MIME multipart mail,
    this attribute represents "preamble".
.

: parts -> Array of TMail::Mail
j
    ᡼뤬 MIME ޥѡȥ᡼λƥѡȤ TMail::Mail Ȥ
    ǼƤޤޥѡȥ᡼ǤʤȤ϶Ǥ

    ˽񤭤ǤɸΥե(ʸ)ѹޤ
    ºݤѹ뤿ˤϤΥ֥Ȥ˽񤭤 #write_back 
    Ƥɬפޤ
e
    parts of this mail. (valid only if this mail is a MIME multipart mail)
.

: epilogue -> String
j
    MIME ޥѡȥ᡼Ǥ epilogue ʸǤ
    ̾Υ᡼ΤȤ϶ʸäƤޤ

    ˽񤭤ǤɸΥե(ʸ)ѹޤ
    ºݤѹ뤿ˤϽ񤭤 #write_back Ƥɬפޤ
e
    If the mail was MIME multipart mail, this represent "epilogue" string.
    Else, empty string.
.

: multipart?
j
    ᡼뤬 MIME ޥѡȤΤȤ
    Υ᥽åɤ Content-Type إåƤǿȽǤޤ
e
    true if the message is a multi-part mail.
.

: encoded( eol = "\n", encoding = 'j' ) -> String
j
    ᡼ RFC2822 ˥󥳡ɤʸѴޤ
    κݡإåιɤ eol ˡإåΥ󥳡
    ܸʸʸɤ encoding Ѵޤ
     encoding  "j" (JIS) ưޤ

    С 0.9  #to_s  #decoded ̾ˤʤäΤǡ
    ᥽åɤȤϰ㤦Ϥ餭򤷤ޤ
e
    converts the mail object to a MIME encoded string.
.

: decoded( eol = "\n", encoding = 'e' ) -> String
: to_s( eol = "\n", encoding = 'e' ) -> String
j
    ᡼ǥɤ줿ʸѴޤκݡإåι
    ɤ eol ˡإåΥ󥳡ܸʸʸɤ
    encoding Ѵޤ

    С 0.9 ʹߤ #to_s ϤΥ᥽åɤ̾ˤʤޤ
e
    converts the mail object to a decoded string.
.

: inspect -> String
j
     #decoded ̾ǤС 0.9 
    "#<TMail::Mail port=<StringPort:str=...>>"
    Τ褦ʴʷʸ󲽤Ԥޤ
e
    returns simple string representation like
    '"#<TMail::Mail port=<StringPort:str=...>>"'
.

: write_back( eol = "\n", encoding = 'e' )
j
    ᡼Τʸ󲽤 body_port ˽ᤷޤκݡإå
    ɤ eol ˡإåܸʸʸɤ encoding 
    Ѵޤ
e
    converts this mail into string and write back to 'body_port',
    setting line terminator to EOL.
.

j
=== °ΤΥ᥽å
e
=== Property Access Method
.

: date( default = nil ) -> Time
j
: date=( datetime: Time )
j
    Date: إåб Time ֥ȡ
    ˥륿Ѵޤ
e
    a time object of Date: header field.
.

: strftime( format: String, default = nil ) -> String
j
    Date: إåɽ줿б Time ֥ȤФ
    strftime ƤӤޤDate: إå¸ߤʤ default 
    ֤ޤ
e
    is equals to 'date.strftime(format)'.
    If date is not exist, this method does nothing and
    returns DEFAULT.
.

: to( default = nil ) -> Array of String
: to=( addrs: String/Array of String )
j
    To: ɥ쥹 spec 
e
    address specs for To: header field.
.

: to_addrs( default = nil ) -> Array of TMail::Address
: to_addrs=( addrs: TMail::Address/Array of TMail::Address )
j
    To: ɥ쥹
e
    adresses which is represented in To: header field.
.

: cc( default = nil ) -> Array of String
: cc=( addrs: String/Array of String )
j
    Cc: ɥ쥹 spec 
e
    address specs for Cc: header field.
.

: cc_addrs( default = nil ) -> Array of TMail::Address
: cc_addrs=( addrs: TMail::Address/Array of TMail::Address )
j
    Cc: ɥ쥹
e
    addresses which is represented in Cc: header field.
.

: bcc( default = nil ) -> Array of String
: bcc=( addrs: String/Array of String )
j
    Bcc: ɥ쥹 spec 
e
    address specs for Bcc: header field.
.

: bcc_addrs( default = nil ) -> Array of TMail::Address
: bcc_addrs=( addrs: TMail::Address/Array of TMail::Address )
j
    Bcc: ɥ쥹
e
    adresses which is represented in Bcc: header field.
.

: from( default = nil ) -> Array of String
: from=( addrs: String/Array of String )
j
    From: ɥ쥹 spec 
e
    address specs for From: header field.
.

: from_addrs( default = nil ) -> Array of TMail::Address
: from_addrs=( addrs: TMail::Address/Array of TMail::Address )
j
    From: ɥ쥹
e
    adresses which is represented in From: header field.
.

: friendly_from( default = nil ) -> String
j
    From: κǽΥɥ쥹 phrase ޤ spec
    From: ¸ߤʤȤ default ֤ޤ
e
    a "phrase" part or address spec of the first From: address.
.

: reply_to( default = nil ) -> Array of String
: reply_to=( addrs: String/Array of String )
j
    Reply-To: ɥ쥹 spec 
e
    address specs of Reply-To: header field.
.

: reply_to_addrs( default = nil ) -> Array of TMail::Address
: reply_to_addrs=( addrs: TMail::Address/Array of TMail::Address )
j
    Reply-To: ɥ쥹
e
    adresses which is represented in Reply-To: header field.
.

: sender( default = nil ) -> String
: sender=( addr: String )
j
    Sender: ɥ쥹 spec
e
    address spec for Sender: header field.
.

: sender_addr( default = nil ) -> TMail::Address
: sender_addr=( addr: TMail::Address )
j
    Sender: ɥ쥹
e
    an address which is represented in Sender: header field.
.

: subject( default = nil ) -> String
: subject=( sbj: String )
j
    Subject: ơ
    Subject: ¸ߤʤȤ default ֤ޤ
e
    the subject of the message.
.

: message_id( default = nil ) -> String
: message_id=( id: String )
j
    ᡼Υå ID
e
    message ID string.
.

: in_reply_to( default = nil ) -> Array of String
: in_reply_to=( ids: String/Array of String )
j
    In-Reply-To: ˴ޤޤå ID Υꥹȡ
e
    message IDs of replying mails.
.

: references( default = nil ) -> Array of String
: references=( ids: String/Array of String )
j
    References: ˴ޤޤå ID Υꥹȡ
    ߤ References: ˤϥå ID ʳ
    ޤޤ(RFC2822)
e
    message IDs of all referencing (replying) mails.
.

: mime_version( default = nil ) -> String
: mime_version=( ver: String )
j
    MIME С󡣸ߤϾ 1.0 Ǥ
    إå¸ߤʤ default ֤ޤ
e
    MIME version.
    If it does not exist, returns the DEFAULT.
.

: set_mime_version( major: Integer, minor: Integer )
j
    MIME С򥻥åȤޤ
e
    set MIME version from integers.
.

: content_type( default = nil ) -> String
j
    ᡼ΤΥե륿פ򼨤ʸ㤨 "text/plain"
    إå¸ߤʤ default ֤ޤ
e
    the content type of the mail message (e.g. "text/plain").
    If it does not exist, returns the DEFAULT.
.

: main_type( default = nil ) -> String
j
    ᡼ΤΥᥤ󥿥 (㡧"text")
    ˾ʸ줵ޤ
    إå¸ߤʤ default ֤ޤ
e
    the main content type of the mail message. (e.g. "text")
    If it does not exist, returns the DEFAULT.
.

: sub_type( default = nil ) -> String
j
    ᡼ΤΥ֥ (㡧"plain")
    ˾ʸ줵ޤ
    إå¸ߤʤ default ֤ޤ
e
    the sub content type of the mail message. (e.g. "plain")
    If it does not exist, returns the DEFAULT.
.

: content_type=( main_sub: String )
j
    Content-Type Υᥤ󥿥ס֥פ main_sub 饻å
    ޤmain_sub 㤨 "text/plain" Τ褦ʷǤʤ
    ޤ
e
    set content type to STR.
.

: set_content_type( main: String, sub: String, params: Hash = nil )
j
    ƥȥפ main/sub; param; param; ... Τ褦ꤷޤ
    params ϡ̾(ʸ)(ʸ)פη Hash Ϳޤ
e
    set Content-type: header as "main/sub; param=val; param=val; ...".
.

: type_param( name: String, default = nil ) -> String
j
    Content-Type  name ѥ᡼֤ͤޤ
    name бͤإåΤΤ¸ߤʤ default 
    ֤ޤ
e
    returns the value corresponding to the case-insensitive
    NAME of Content-Type parameter.
    If it does not exist, returns the DEFAULT.
.
      --
      # example
      mail['Content-Type'] = 'text/plain; charset=iso-2022-jp'
      p mail.type_param('charset')   # "iso-2022-jp"
      --

: multipart? -> bool
j
    Content-Type  MIME ޥѡȥ᡼Ǥ뤳Ȥ
    Ƥʤп
e
    judge if this mail is MIME multi part mail,
    by inspecting Content-Type: header field.
.

: transfer_encoding( default = nil ) -> String
: transfer_encoding=( str: String )
j
    žŬѤ󥳡ǥ (Content-Transfer-Encoding)
    '7bit' '8bit' 'Base64' 'Binary' ʤɡ
e
    Content-Transfer-Encoding. (e.g. "7bit" "Base64")
.

: disposition( default = nil ) -> String
j
: disposition=( disp: String )
j
    Content-Disposition μ (ʸ)֤ͤϾ˾ʸ줵ޤ
    name бͤإåΤΤ¸ߤʤ default 
    ֤ޤ
e
    Content-Disposition main value (e.g. "attach").
    If it does not exist, returns the DEFAULT.
.
      --
      # example
      mail['Content-Disposition'] = 'attachement; filename="test.rb"'
      p mail.disposition   # "attachment"
      --

: set_content_disposition( pos: String, params: Hash = nil )
j
    disposition ʸȥѥ᡼Υϥå夫 Content-Disposition 
    åȤޤparams ϡ̾(ʸ)(ʸ)פη Hash Ǥ
e
    set content disposition.
    PARAMS is a Hash, like {"name"=>"value"}.
.

: disposition_param( name: String, default = nil ) -> String
j
    Content-Disposition ղåѥ᡼ name ͤޤ
    name бͤإåΤΤ¸ߤʤ default 
    ֤ޤ
e
    returns a value corresponding to the Content-Disposition
    parameter NAME (e.g. filename).
    If it does not exist, returns the DEFAULT.
.
      --
      # example
      mail.disposition_param('filename')
      -- 

: destinations( default = nil ) -> Array of String
j
    ToCcBcc ٤ƤΥɥ쥹ڥåʸ
    ֤ޤҤȤĤ¸ߤʤ default ֤ޤ
e
    all address specs which are contained in To:, Cc: and
    Bcc: header fields.
.

: reply_addresses( default = nil ) -> Array of TMail::Address
j
    ֿ٤ɥ쥹ȽǤAddress ֥Ȥ
    ֤ޤֿ٤ɥ쥹ߤĤʤ
    DEFAULT ֤ޤ
e
    addresses to we reply to.
.

: error_reply_addresses( default = nil ) -> Array of TMail::Address
j
    顼᡼٤ɥ쥹ȽǤAddress ֥Ȥ
    ֤ޤ٤ɥ쥹ߤĤʤ default ֤ޤ
e
    addresses to use when returning error message.
.

j
=== إåեľѥ᥽å
e
=== Direct Header Handling Methods
.

: clear
j
    إåƾõޤ
e
    clears all header.
.

: keys -> Array of TMail::HeaderField
j
    إå֤̾ޤ
e
    returns an array of contained header names.
.

: []( name ) -> TMail::HeaderField
j
    إå̾إå֥Ȥ֤ޤ
e
    returns a header field object corresponding to the case-insensitive
    key NAME. e.g. mail["To"]
.

: []=( name, field )
j
    name إå field ꤷޤfield ʸ TMail::HeaderField ֥ȤǤ
    Received ʤɰΥإåФƤϤˤͿ뤳ȤǤޤ
e
    set NAME header field to FIELD.
.

: delete( key )
j
    key إåäޤ
e
    deletes header corresponding to case-insensitive key KEY.
.

: delete_if {|key, val| .... }
j
    إå̾ȥإåͿƥ֥åɾʤ餽δϢŤäޤ
e
    evaluates block with a name of header and header field object,
    and delete the header if block returns true.
.

: each_header {|name, field| .... }
: each_pair {|name, field| .... }
j
    ƤΥإå̾ȥإå֥ȤФ뤯꤫
e
    iterates for each header name and its field object.
.

: each_header_name {|name| .... }
: each_key {|name| .... }
j
    ƤΥإå̾Ф뤯꤫
e
    iterates for each contained header names.
.

: each_field {|field| .... }
: each_value {|field| .... }
j
    ƤΥإå֥ȤФ뤯꤫
e
    iterates for each header field objects.

: orderd_each {|name, field| .... }
j
    إåνդ each_header Ǥǽ˻ꤷΤꤷ
    ֤¤ӡ¾Υإå³ޤʸ
    TMail::Mail::FIELD_ORDER ꤷƤ(ܺ٤ϥɤ򻲾)
e
    iterates for each header field objects, in canonical order.
.

: key?( name )
j
    name إåп
e
    returns true if the mail has NAME header.
.

: value?( field )
j
    field إå֥Ȥп
e
    returns true if the mail has FIELD header field object.
.

: values_at( *keys ) -> Array of TMail::HeaderField
: indexes( *keys ) -> Array of TMail::HeaderField
: indices( *keys ) -> Array of TMail::HeaderField
j
    Ƥ keys ˤĤ fetch ̤֤ޤ
e
    equals to 'keys.collect {|k| mail[k] }'.
.

: values -> Array of TMail::HeaderField
j
    ϿƤƤΥإå֥Ȥ֤ޤ
e
    returns an array of all header field object.
.
