/* Hey EMACS -*- linux-c -*- */
/* $Id: keys73.c 3175 2007-02-19 17:54:59Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2007  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ticalcs.h"
#include "keys73.h"

/*
  Conversion of an ASCII code into a TI key.
  This table is very incomplete. It contains most of ASCII chars only.
  Same for TI73/TI83.
*/
const OldCalcKeys_ TI73_KEYS[] = 
{
/* 0x00 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"Enter", "Enter", KEY73_Enter, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x10 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"ESC", "Quit", KEY73_Quit, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x20 */
  {" ", "Space", KEY73_Space, "", 0, "", 0, "", 0, "", 0},
  {"!", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"\"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"#", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"$", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"%", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"&", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"'", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"(", "LParen", KEY73_LParen, "", 0, "", 0, "", 0, "", 0},
  {")", "RParen", KEY73_RParen, "", 0, "", 0, "", 0, "", 0},
  {"*", "Mul", KEY73_Mul, "", 0, "", 0, "", 0, "", 0},
  {"+", "Add", KEY73_Add, "", 0, "", 0, "", 0, "", 0},
  {",", "Comma", KEY73_Comma, "", 0, "", 0, "", 0, "", 0},
  {"-", "Sub", KEY73_Sub, "", 0, "", 0, "", 0, "", 0},
  {".", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"/", "Div", KEY73_Div, "", 0, "", 0, "", 0, "", 0},
/* 0x30 */
  {"0", "0", KEY73_0, "", 0, "", 0, "", 0, "", 0},
  {"1", "1", KEY73_1, "", 0, "", 0, "", 0, "", 0},
  {"2", "2", KEY73_2, "", 0, "", 0, "", 0, "", 0},
  {"3", "3", KEY73_3, "", 0, "", 0, "", 0, "", 0},
  {"4", "4", KEY73_4, "", 0, "", 0, "", 0, "", 0},
  {"5", "5", KEY73_5, "", 0, "", 0, "", 0, "", 0},
  {"6", "6", KEY73_6, "", 0, "", 0, "", 0, "", 0},
  {"7", "7", KEY73_7, "", 0, "", 0, "", 0, "", 0},
  {"8", "8", KEY73_8, "", 0, "", 0, "", 0, "", 0},
  {"9", "9", KEY73_9, "", 0, "", 0, "", 0, "", 0},
  {":", "", 0, "", 0, "", 0, "", 0, "", 0},
  {";", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"<", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"=", "", 0, "", 0, "", 0, "", 0, "", 0},
  {">", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"?", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x40 */
  {"@", "@", 0, "", 0, "", 0, "", 0, "", 0},
  {"A", "A", KEY73_CapA, "", 0, "", 0, "", 0, "", 0},
  {"B", "B", KEY73_CapB, "", 0, "", 0, "", 0, "", 0},
  {"C", "C", KEY73_CapC, "", 0, "", 0, "", 0, "", 0},
  {"D", "D", KEY73_CapD, "", 0, "", 0, "", 0, "", 0},
  {"E", "E", KEY73_CapE, "", 0, "", 0, "", 0, "", 0},
  {"F", "F", KEY73_CapF, "", 0, "", 0, "", 0, "", 0},
  {"G", "G", KEY73_CapG, "", 0, "", 0, "", 0, "", 0},
  {"H", "H", KEY73_CapH, "", 0, "", 0, "", 0, "", 0},
  {"I", "I", KEY73_CapI, "", 0, "", 0, "", 0, "", 0},
  {"J", "J", KEY73_CapJ, "", 0, "", 0, "", 0, "", 0},
  {"K", "K", KEY73_CapK, "", 0, "", 0, "", 0, "", 0},
  {"L", "L", KEY73_CapL, "", 0, "", 0, "", 0, "", 0},
  {"M", "M", KEY73_CapM, "", 0, "", 0, "", 0, "", 0},
  {"N", "N", KEY73_CapN, "", 0, "", 0, "", 0, "", 0},
  {"O", "O", KEY73_CapO, "", 0, "", 0, "", 0, "", 0},
/* 0x50 */
  {"P", "P", KEY73_CapP, "", 0, "", 0, "", 0, "", 0},
  {"Q", "Q", KEY73_CapQ, "", 0, "", 0, "", 0, "", 0},
  {"R", "R", KEY73_CapR, "", 0, "", 0, "", 0, "", 0},
  {"S", "S", KEY73_CapS, "", 0, "", 0, "", 0, "", 0},
  {"T", "T", KEY73_CapT, "", 0, "", 0, "", 0, "", 0},
  {"U", "U", KEY73_CapU, "", 0, "", 0, "", 0, "", 0},
  {"V", "V", KEY73_CapV, "", 0, "", 0, "", 0, "", 0},
  {"W", "W", KEY73_CapW, "", 0, "", 0, "", 0, "", 0},
  {"X", "X", KEY73_CapX, "", 0, "", 0, "", 0, "", 0},
  {"Y", "Y", KEY73_CapY, "", 0, "", 0, "", 0, "", 0},
  {"Z", "Z", KEY73_CapZ, "", 0, "", 0, "", 0, "", 0},
  {"[", "LBrack", KEY73_LBrack, "", 0, "", 0, "", 0, "", 0},
  {"\\", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"]", "RBrack", KEY73_RBrack, "", 0, "", 0, "", 0, "", 0},
  {"^", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"_", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x60 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"a", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"b", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"c", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"d", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"e", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"f", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"g", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"h", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"i", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"j", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"k", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"l", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"m", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"n", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"o", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x70 */
  {"p", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"q", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"r", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"s", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"t", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"u", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"v", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"w", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"x", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"y", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"z", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"{", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"|", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"}", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"~", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x80 */
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"\173", "Ans", KEY73_Ans, "\173", 173, "ANS", 4372, "", 8365, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
  {"", "", 0, "", 0, "", 0, "", 0, "", 0},
/* 0x90 */
};
