/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDIIHSFUSIONSTRATEGY_HPP
  #define TEPDIIHSFUSIONSTRATEGY_HPP


  #include "TePDIStrategy.hpp"

  /**
   * @brief This is the class for IHS fusion strategy.
   * @author Emiliano F. Castejon <castejon@dpi.inpe.br>
   * @ingroup PDIStrategies
   *
   * @note The required parameters are:
   * @param fusion_type ( std::string ) : Must be "ihs".
   * @param reference_raster ( TePDITypes::TePDIRasterPtrType ) - 
   *  Reference raster ( higher quality ).
   * @param lowres_raster ( TePDITypes::TePDIRasterPtrType ) - 
   *  Low resolution RGB raster with 3 channels ( will be improved  - 
   * band0=Red, band1=Green, band2=Blue ).
   * @param output_raster ( TePDITypes::TePDIRasterPtrType ) - Output raster.
   * @param reference_raster_band ( int ) - The band to process from 
   * reference_raster.
   *
   */
  class PDI_DLL TePDIIHSFusionStrategy : public TePDIStrategy
  {
    friend class TePDIIHSFusionSF;
  
    public :
      
      /**
       * @brief Default Destructor
       */
      ~TePDIIHSFusionStrategy();
      
      /**
       * @brief Checks if the supplied parameters fits the requirements of each
       * PDI strategy.
       *
       * @note Error log messages must be generated. No exceptions generated.
       *
       * @param parameters The parameters to be checked.
       * @return true if the parameters are OK. false if not.
       */
      bool CheckParameters( 
        const TePDIParameters& parameters ) const;       
      
    protected :
      
      /**
       * @brief Default constructor
       *
       * @param factoryName Factory name.
       */
      TePDIIHSFusionStrategy();
      
      /**
       * @brief Runs the algorithm implementation.
       *
       * @return true if OK. false on errors.
       */
      bool Implementation( const TePDIParameters& params );
      
  };
  
#endif



