/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
/*! \file TeDecoderMemory.h
    This file deals with decoding of raster structures as a mulitdimensional matrix in memory
*/
#ifndef  __TERRALIB_INTERNAL_DECODERMEMORY_H
#define  __TERRALIB_INTERNAL_DECODERMEMORY_H

#include <TeDecoder.h>

//! Implements a decoder to a raster stored as a as a mulitdimensional matrix in memory
class TeDecoderMemory : public TeDecoder
{
	bool allocateMemory();
	bool resetMemory();

public:

	//! Empty constructor
	TeDecoderMemory ( ) : 
		data_(0), 
		isModified_(false) 
		{ params_.decoderIdentifier_ = "MEM";};

	//! Constructor from parameters
	TeDecoderMemory ( const TeRasterParams& par ) : 
		data_(0),
		isModified_(false)
	{	
		params_ = par; 
		params_.decoderIdentifier_ = "MEM"; 
	};

	//! Destructor
	virtual ~TeDecoderMemory ();

	bool setElement (int col,int lin, double val, int band=0);
	bool getElement (int col,int lin, double &val,int band=0);

	//! Returns  the pointer to the matrix structure in memory
	void* data () { return data_; }

	//! Retuns a ponter to a given band
	void* data (int band=0);

	virtual void	init	();
	virtual bool	clear	();

	void setModified(bool val)
	{	isModified_ = val; }

protected:
	int	nelems_;
	int	size_;
	void*	data_;			//!< Pointer to view of file mapped to memory
	bool isModified_;
};

//! Implements a factory to build decoder to MEMORY raster
class TeDecoderMemoryFactory : public TeDecoderFactory
{
public:

	TeDecoderMemoryFactory(const string& name) : TeDecoderFactory(name) {}

	virtual TeDecoder* build (const TeRasterParams& arg)
	{  return new TeDecoderMemory(arg); }
};
#endif

