#include "TePDIRgbPalette.hpp"

#include "TePDIAgnostic.hpp"

#include <math.h>


TePDIRgbPalette::iterator::iterator(
  const std::map< double, unsigned int >::iterator& red_it,
  const std::map< double, unsigned int >::iterator& green_it,
  const std::map< double, unsigned int >::iterator& blue_it )
{
  red_it_ = red_it;
  green_it_ = green_it;
  blue_it_ = blue_it;
}


TePDIRgbPalette::iterator::~iterator()
{
}


void TePDIRgbPalette::iterator::operator++()
{
  ++red_it_;
  ++green_it_;
  ++blue_it_;
}


void TePDIRgbPalette::iterator::operator--()
{
  --red_it_;
  --green_it_;
  --blue_it_;
}


void TePDIRgbPalette::iterator::operator=( const iterator& ext_ref )
{
  red_it_ = ext_ref.red_it_;
  green_it_ = ext_ref.green_it_;
  blue_it_ = ext_ref.blue_it_;
}


bool TePDIRgbPalette::iterator::operator!=( const iterator& ext_ref )
{
  return ( red_it_ != ext_ref.red_it_ ) ? true : false;
}


double TePDIRgbPalette::iterator::level() const
{
  return red_it_->first;
}


unsigned int TePDIRgbPalette::iterator::red() const
{
  return red_it_->second;
}


unsigned int TePDIRgbPalette::iterator::green() const
{
  return green_it_->second;
}


unsigned int TePDIRgbPalette::iterator::blue() const
{
  return blue_it_->second;
}


TePDIRgbPalette::TePDIRgbPalette()
{
}


TePDIRgbPalette::~TePDIRgbPalette()
{
}

void TePDIRgbPalette::set( double level, unsigned int red,
  unsigned int green, unsigned int blue )
{
  red_map_[ level ] = red;
  green_map_[ level ] = green;
  blue_map_[ level ] = blue;
}

bool TePDIRgbPalette::get( double level, unsigned int& red,
  unsigned int& green, unsigned int& blue ) const
{
  if( red_map_.find( level ) != red_map_.end() ) {
    red = red_map_[ level ];
    green = green_map_[ level ];
    blue = blue_map_[ level ];

    return true;
  } else {
    return false;
  }
}


void TePDIRgbPalette::clear()
{
  red_map_.clear();
  green_map_.clear();
  blue_map_.clear();
}


unsigned long int TePDIRgbPalette::size() const
{
  return red_map_.size();
}


void TePDIRgbPalette::operator=( TePDIRgbPalette& external_reference )
{
  red_map_ = external_reference.red_map_;
  green_map_ = external_reference.green_map_;
  blue_map_ = external_reference.blue_map_;
}


TePDIRgbPalette::iterator TePDIRgbPalette::begin() const
{
  TePDIRgbPalette::iterator temp_it( red_map_.begin(), green_map_.begin(),
    blue_map_.begin() );

  return temp_it;
}


TePDIRgbPalette::iterator TePDIRgbPalette::end() const
{
  TePDIRgbPalette::iterator temp_it( red_map_.end(), green_map_.end(),
    blue_map_.end() );

  return temp_it;
}


TePDISharedPtr< TePDIRgbPalette > TePDIRgbPalette::createLB(
  unsigned int levels )
{
  PDIAGN_TRUE_OR_THROW( levels > 0, "Invalid supplied Levels" );

  unsigned int channel_levels =
    (unsigned int) ceil( cbrtf( (float)levels ) );

  unsigned int channel_step =
    (unsigned int) floor( 256. / (float)(channel_levels + 1) );

  unsigned int red_level = 0;
  unsigned int green_level = 0;
  unsigned int blue_level = 0;

  TePDISharedPtr< TePDIRgbPalette > outPal( new TePDIRgbPalette );

  unsigned int level = 0;

  while( level < levels ) {
    if( red_level > 255 ) {
      red_level = red_level % 255;

      green_level += channel_step;

      if( green_level > 255 ) {
        green_level = green_level % 255;

        blue_level += channel_step;

        if( blue_level > 255 ) {
          blue_level = blue_level % 255;
        }
      }
    }

    outPal->set( (double)level, red_level, green_level, blue_level );

    red_level += channel_step;

    ++level;
  }

  return outPal;
}
