<!-- Stylesheet to extract interface names from the Telepathy spec,
based on c-interfaces-generator.xsl.

The output of c-interfaces-generator.xsl has to be altered to be API
compatible with libtelepathy: connection interfaces contain CONN rather than
CONNECTION.

Copyright (C) 2007 Collabora Limited

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:tp="http://telepathy.freedesktop.org/wiki/DbusSpec#extensions-v0"
  exclude-result-prefixes="tp">

  <xsl:output method="text" indent="no" encoding="ascii"/>

  <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
  <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>

  <xsl:template name="mangle-name">
    <xsl:param name="in" select="''"/>
    <xsl:choose>
      <!-- world's least efficient replace() -->
      <xsl:when test="contains($in, 'Connection')">
        <xsl:call-template name="mangle-name">
          <xsl:with-param name="in"
            select="concat(substring-before($in, 'Connection'), 'Conn',
                           substring-after($in, 'Connection'))"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$in"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="interface">
    <xsl:variable name="name">
      <xsl:call-template name="mangle-name">
        <xsl:with-param name="in" select="../@name"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:text>#define TP_IFACE_</xsl:text>
    <xsl:value-of select="translate($name, concat($lower, '/'), $upper)"/> \
        "<xsl:value-of select="@name"/>"
</xsl:template>

  <xsl:template match="text()"/>

  <xsl:template match="/tp:spec">/* Generated from the Telepathy spec

<xsl:for-each select="tp:copyright">
<xsl:value-of select="."/><xsl:text>
</xsl:text></xsl:for-each><xsl:text>
</xsl:text><xsl:value-of select="tp:license"/>
<xsl:value-of select="tp:docstring"/>
*/

<xsl:apply-templates select="node"/>
</xsl:template>

</xsl:stylesheet>

<!-- vim:set sw=2 sts=2 et noai noci: -->
