/*
 * Serialize a tagged collection to a text file
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/TagcollSerializer.h>

#include <tagcoll/stringf.h>

using namespace std;
using namespace stringf;
using namespace Tagcoll;

void TagcollSerializer::printTagset(const OpSet<string>& ts) throw ()
{
	for (OpSet<string>::const_iterator i = ts.begin();
			i != ts.end(); i++)
		if (i == ts.begin())
			fprintf(out, "%.*s", PFSTR(*i));
		else
			fprintf(out, ", %.*s", PFSTR(*i));
}

void TagcollSerializer::consume(const string& item) throw ()
{
	fprintf(out, "%.*s\n", PFSTR(item));
}

void TagcollSerializer::consume(const string& item, const OpSet<string>& tags) throw ()
{
	fprintf(out, "%.*s: ", PFSTR(item));
	printTagset(tags);
	fprintf(out, "\n");
}

void TagcollSerializer::consume(const OpSet<string>& items) throw ()
{
	printTagset(items);
	fprintf(out, "\n");
}

void TagcollSerializer::consume(const OpSet<string>& items, const OpSet<string>& tags) throw ()
{
	printTagset(items);
	fprintf(out, ": ");
	printTagset(tags);
	fprintf(out, "\n");
}

// vim:set ts=4 sw=4:
