/* ShowWindow.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.commands;

import java.awt.Window;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

/**
 * Action command that makes a particular window visible (if it was not) and brings it
 * to the front.<p>
 *
 * <b>Important note:</b> work on this part of the Swirl library will be 
 * discontinued because unfortunately newer versions
 * of the <i>GUI commands</i> framework will no longer be available as <i>open source</i>.
 * In due course this class will become deprecated and will eventually be
 * removed from the library.
 */
public class ShowWindow extends ActionCommand {
    
    //
    private final Window window;
    
    /** Default constructor */
    public ShowWindow (CommandManager commandManager, String id, Window window) {
        super (commandManager, id);
        this.window = window;
    }
    
    /**
     * Makes the associated window visible and brings it to the front.
     */
    public void handleExecute () {
        window.setVisible (true);
        window.toFront ();
    }
}
